package com.bxm.adsmanager.model.dto.monitor;
import java.io.Serializable;
import java.util.List;
/**
 * 
* @Title:TicketUrlDto.java
* @Package:com.bxm.adsmanager.model.dto.monitor
* @Description: 广告落地页查询实体类
* @date:2018年10月8日 下午2:18:45
* @author wangchao
 */
public class TicketUrlDto implements Serializable{

    private static final long serialVersionUID = -6265256845417594641L;
    
    /**
     * 广告名称或者id
     */
    private String keywords;
    /**
     * 广告ID
     */
    private Long certificateId;
    
    /**
     * 广告名称
     */
    private String certificateName;
    
    /**
     * 查询的广告ID的集合
     */
    private List<Long> certificateIds;
    
    /**
     * 排除查询的广告ID的集合
     */
    private List<Long> excludeCertificateIds;
     
    
    /**
     * AE编码
     */
    private String aeCode;

    /**
    * sale编码
    * */
    private String sale;
    
    /**
     * 点击量
     */
    private Double clickPv;
    
    /**
     * 落地页到达率(最大)
     */
    private Double exposureRateMax;
    
    /**
     * 落地页到达率(最小)
     */
    private Double exposureRateMin;
    
    /**
     * 页面号
     */
    private Integer pageNum = 1;
    
    /**
     * 页面大小
     */
    private Integer pageSize = 20;
    
    /**
     * 开始查询时间
     */
    private String startTime;
    
    /**
     * 结束查询时间
     */
    private String endTime;
    
    /**
     * 监控时间段,近多少小时
     */
    private Integer monitorPeriod;
    
    public String getKeywords() {
        return keywords;
    }

    public void setKeywords(String keywords) {
        this.keywords = keywords;
    }

    public Long getCertificateId() {
        return certificateId;
    }

    public void setCertificateId(Long certificateId) {
        this.certificateId = certificateId;
    }

    public Double getClickPv() {
        return clickPv;
    }

    public void setClickPv(Double clickPv) {
        this.clickPv = clickPv;
    }

    public Double getExposureRateMax() {
        return exposureRateMax;
    }

    public void setExposureRateMax(Double exposureRateMax) {
        this.exposureRateMax = exposureRateMax;
    }

    public Double getExposureRateMin() {
        return exposureRateMin;
    }

    public void setExposureRateMin(Double exposureRateMin) {
        this.exposureRateMin = exposureRateMin;
    }

    public Integer getPageNum() {
        return pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public String getAeCode() {
        return aeCode;
    }

    public void setAeCode(String aeCode) {
        this.aeCode = aeCode;
    }

    public List<Long> getCertificateIds() {
        return certificateIds;
    }

    public void setCertificateIds(List<Long> certificateIds) {
        this.certificateIds = certificateIds;
    }

    public List<Long> getExcludeCertificateIds() {
        return excludeCertificateIds;
    }

    public void setExcludeCertificateIds(List<Long> excludeCertificateIds) {
        this.excludeCertificateIds = excludeCertificateIds;
    }

    public String getCertificateName() {
        return certificateName;
    }

    public void setCertificateName(String certificateName) {
        this.certificateName = certificateName;
    }

    public String getStartTime() {
        return startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public String getEndTime() {
        return endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public Integer getMonitorPeriod() {
        return monitorPeriod;
    }

    public void setMonitorPeriod(Integer monitorPeriod) {
        this.monitorPeriod = monitorPeriod;
    }

    public String getSale() {
        return sale;
    }

    public void setSale(String sale) {
        this.sale = sale;
    }
}
