package com.bxm.adsmanager.model.dto.outside;

import org.hibernate.validator.constraints.NotBlank;

import javax.validation.constraints.NotNull;
import java.math.BigInteger;

/**
 * 礼券外投传输对象
 *
 * @ClassName AdTicketOutsideDto
 * @CopyRright (c) 2018-bxm：杭州微财网络科技有限公司
 * @Author kk.xie
 * @Date 2018/6/15 16:28
 * @Version 1.0
 * @Modifier kk.xie
 * @Modify Date 2018/6/15 16:28
 **/
public class AdTicketOutsideDto {
    /**
     * 广告主原始落地页
     */
    @NotBlank(message = "广告主原始落地页不能为空！")
    private String url;

    /**
     * 素材ID
     */
    @NotNull(message = "广告券素材ID不能为空！")
    private BigInteger assetId;

    /**
     * 点击率下限
     */
    @NotNull(message = "点击率下限不能为空！")
    private Integer clickRateMin; 

    /**
     * 点击率上限
     */
    @NotNull(message = "点击率上限不能为空！")
    private Integer clickRateMax;

    /**
     * 投放链接
     */
    @NotBlank(message = "投放链接不能为空！")
    private String outsideUrl;

    /**
     * 礼券ID
     */
    @NotNull(message = "礼券ID不能为空！")
    private BigInteger ticketId;
    
    
    private int timeByIP=300;//时间频率限制  5分钟内，单IP用户可访问 countByIp 次数
    
    private int countByIp=1; //次数
    
    private int totalTimeByIP=60*60*24*5; // 类型totalTimeByIP 时间访问totalCountByIp次，
    
    private int totalCountByIp=3; //次数
    
    private Long enableTime=60*60*24*365L;//禁用时间

    
    
    public int getTimeByIP() {
        return timeByIP;
    }

    
    public void setTimeByIP(int timeByIP) {
        this.timeByIP = timeByIP;
    }

    
    public int getCountByIp() {
        return countByIp;
    }

    
    public void setCountByIp(int countByIp) {
        this.countByIp = countByIp;
    }

    
    public int getTotalTimeByIP() {
        return totalTimeByIP;
    }

    
    public void setTotalTimeByIP(int totalTimeByIP) {
        this.totalTimeByIP = totalTimeByIP;
    }

    
    public int getTotalCountByIp() {
        return totalCountByIp;
    }

    
    public void setTotalCountByIp(int totalCountByIp) {
        this.totalCountByIp = totalCountByIp;
    }

    
    public Long getEnableTime() {
        return enableTime;
    }

    
    public void setEnableTime(Long enableTime) {
        this.enableTime = enableTime;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public BigInteger getAssetId() {
        return assetId;
    }

    public void setAssetId(BigInteger assetId) {
        this.assetId = assetId;
    }

    public Integer getClickRateMin() {
        return clickRateMin;
    }

    public void setClickRateMin(Integer clickRateMin) {
        this.clickRateMin = clickRateMin;
    }

    public Integer getClickRateMax() {
        return clickRateMax;
    }

    public void setClickRateMax(Integer clickRateMax) {
        this.clickRateMax = clickRateMax;
    }

    public String getOutsideUrl() {
        return outsideUrl;
    }

    public void setOutsideUrl(String outsideUrl) {
        this.outsideUrl = outsideUrl;
    }

    public BigInteger getTicketId() {
        return ticketId;
    }

    public void setTicketId(BigInteger ticketId) {
        this.ticketId = ticketId;
    }

    @Override
    public String toString() {
        return "AdTicketOutsideDto{" +
                "url='" + url + '\'' +
                ", assetId=" + assetId +
                ", clickRateMin=" + clickRateMin +
                ", clickRateMax=" + clickRateMax +
                ", outsideUrl='" + outsideUrl + '\'' +
                ", ticketId=" + ticketId +
                '}';
    }
}
