package com.bxm.adsmanager.model.dto.overseas;

import com.bxm.adsmanager.model.dao.overseas.OverseasOfflineAdvert;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * 这样做的目的是为了 能否拿到全部数据进行对比删除
 *
 * @author zhangdong
 * @date 2022/10/28
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class OverseasOfflineAdSyncDto implements Serializable {

    /**
     * 需要同步的数据 可能是部分数据 必填
     */
    private List<OverseasOfflineAdvert> data;
    /**
     * true代表部分数据  false代表所有数据 必填  true时 total和time二选一
     */
    private Boolean part;
    /**
     * 数据总数 part为true时 可以使用
     */
    private Integer total;
    /**
     * 请求需要的时间 part为true时 可以使用
     */
    private Long time;
    /**
     * 批次id 唯一递增  必填
     */
    private Long batchId;

    private Long expireTime;
}
