package com.bxm.adsmanager.model.dto.overseas;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author zhangdong
 * @date 2022/10/27
 */
@Data
public class OverseasOfflineAdvertDto implements Serializable {

    /**
     * 合作方列表
     */
    private List<Integer> offerSource;
    /**
     * 推广id/名称
     */
    private String offerId;
    /**
     * 国家
     */
    private String offerCountry;
    /**
     * 结算类型
     */
    private Integer payType;
    /**
     * 状态
     */
    private Integer offerStatus;
    /**
     * 平台
     */
    private String targetPlatform;
    /**
     * 分页号 默认 1
     */
    private Integer pageNum = 1;
    /**
     * 分页大小 默认 10
     */
    private Integer pageSize = 10;

}
