package com.bxm.adsmanager.model.dto.position;

import org.hibernate.validator.constraints.NotBlank;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author: zm
 * @date: 2019-09-24 16:21
 * @Description: 广告位直投券流量占比分配dto
 */
public class PositionDirectFlowAssignDto implements Serializable {

    private static final long serialVersionUID = -6878029870715095934L;

    /**
     * 广告位id
     */
    @NotBlank(message = "请先选择对应的广告位")
    private String positionId;

    /**
     * 流量占比 (0-100)
     */
    @NotNull(message = "请设置直投券流量分配,范围在0-100")
    @Max(value = 100,message = "直投券流量分配最大值为100")
    @Min(value = 0,message = "直投券流量分配最小值为0")
    private Integer directTicketRatio;

    public String getPositionId() {
        return positionId;
    }

    public void setPositionId(String positionId) {
        this.positionId = positionId;
    }

    public Integer getDirectTicketRatio() {
        return directTicketRatio;
    }

    public void setDirectTicketRatio(Integer directTicketRatio) {
        this.directTicketRatio = directTicketRatio;
    }
}
