package com.bxm.adsmanager.model.dto.rta;

import lombok.Data;
import org.hibernate.validator.constraints.NotBlank;

import javax.validation.constraints.NotNull;
import java.util.Date;

/**
 * @author tangx
 * @date 2022/8/15 14:10
 */
@Data
public class RtaDto {
    /**
     * 自增id
     */
    @NotNull(groups = Update.class, message = "id不能为空" )
    private Integer id;

    /**
     * rta id
     */
    private String rtaId;

    /**
     * rta媒体
     */
    @NotBlank(groups = {Add.class, Update.class}, message = "rtaMedia不能为空")
    private String rtaMedia;

    /**
     * rta产品名称
     */
    @NotBlank(groups = {Add.class, Update.class}, message = "rtaProduct不能为空")
    private String rtaProduct;

    /**
     * 最高qps
     */
    @NotBlank(groups = {Add.class, Update.class}, message = "qps不能为空")
    private Integer qps;

    /**
     * 数据源类型 1.广告主RTA 2.内部人群包
     */
    @NotBlank(groups = {Add.class, Update.class}, message = "sourceType不能为空")
    private Byte sourceType;

    /**
     * 定向的广告主rta
     */
    private Integer rtaTarget;

    /**
     * rta定制参数
     */
    private String rtaParam;

    /**
     * 定向的人群包id 规则：白名单id&黑名单id
     */
    private String crowdPackageRule;


    public interface Add {
    }

    public interface Update {
    }
}
