package com.bxm.adsmanager.model.dto.tbltag;

import com.bxm.adsmanager.model.base.BaseDto;
import org.hibernate.validator.constraints.NotBlank;

import javax.validation.constraints.NotNull;
import java.util.Date;

/**
 * @author gaoshihao
 * @version v1.1.4_Report
 * @fileName com.bxm.adsmanager.model.dto.tbltag.TblAdTagDto.java
 * @CopyRright (c) 2018-微财科技有限公司
 * @created 2018-04-27 09:49:00
 * @modifier gaoshihao
 * @updated 2018-04-27 09:49:00
 */
public class TblAdTagDto extends BaseDto {

    @NotNull(message = "id不能为空", groups = { TblAdTagDto.Add.class, TblAdTagDto.Update.class })
    private Integer id;

    @NotBlank(message = "name不能为空", groups = { TblAdTagDto.Add.class, TblAdTagDto.Update.class })
    private String name;

    @NotNull(message = "类型不能为空", groups = { TblAdTagDto.Add.class, TblAdTagDto.Update.class })
    private Integer typeTag;

    @NotNull(message = "父亲ID不能为空", groups = { TblAdTagDto.Add.class, TblAdTagDto.Update.class })
    private Integer parentId;
    public interface Add {
    }

    public interface Update {
    }

    @Override
    public Integer getId() {
        return id;
    }

    @Override
    public void setId(Integer id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getTypeTag() {
        return typeTag;
    }

    public void setTypeTag(Integer typeTag) {
        this.typeTag = typeTag;
    }

    public Integer getParentId() {
        return parentId;
    }

    public void setParentId(Integer parentId) {
        this.parentId = parentId;
    }
}
