package com.bxm.adsmanager.model.enums;

/**
 * adx出价类型-adx结算方式.</br>
 * Created by zhengwangeng on 2021/10/22.
 */
public enum AdxPriceTypeEnum {

    /**
     * CPM
     */
    CPM((short)1, "CPM"),
    /**
     * CPC
     */
    CPC((short)2, "CPC"),
    /**
     * oCPC
     */
    OCPC((short)3, "oCPC"),
    ;

    private short type;
    private String desc;

    public short getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    AdxPriceTypeEnum(short type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static AdxPriceTypeEnum getByType(short type) {
        for (AdxPriceTypeEnum anEnum : AdxPriceTypeEnum.values()) {
            if (anEnum.getType() == type) {
                return anEnum;
            }
        }
        return null;
    }

}
