package com.bxm.adsmanager.model.enums;

/**
 * 投放方式类型：1常规投放，2券码类投放，3激励视频投放
 * Created by zhengwangeng on 2019/8/2.
 */
public enum AppEntrancePutinTypeEnum {

    NORMAL((byte) 1, "常规投放"),
    COUPON((byte) 2, "券码类投放"),
    INSPRE_VIDEO((byte) 3, "激励视频投放");

    private Byte type;

    private String name;

    AppEntrancePutinTypeEnum(Byte type, String name) {
        this.type = type;
        this.name = name;
    }

    public Byte getType() {
        return type;
    }

    public String getName() {
        return name;
    }

    public static AppEntrancePutinTypeEnum getByCode(Byte type) {
        if (null == type) {
            return null;
        }
        for (AppEntrancePutinTypeEnum appEntrancePutinTypeEnum : AppEntrancePutinTypeEnum.values()) {
            if (appEntrancePutinTypeEnum.getType().equals(type)) {
                return appEntrancePutinTypeEnum;
            }
        }
        return null;
    }

}
