package com.bxm.adsmanager.model.enums;

/**
 * SDK模板类型
 */
public enum AssetsTemplateSdkTemplateTypeEnum {

    IMAGE(1, "图片"),
    VIDEO(2, "视频"),
    ANIMATION(3, "动画弹窗");

    private Integer type;

    private String name;

    AssetsTemplateSdkTemplateTypeEnum(Integer type, String name) {
        this.type = type;
        this.name = name;
    }

    public Integer getType() {
        return type;
    }

    public String getName() {
        return name;
    }

    public static AssetsTemplateSdkTemplateTypeEnum getByCode(Integer type) {
        if (null == type) {
            return null;
        }
        for (AssetsTemplateSdkTemplateTypeEnum appEntrancePutinTypeEnum : AssetsTemplateSdkTemplateTypeEnum.values()) {
            if (appEntrancePutinTypeEnum.getType().equals(type)) {
                return appEntrancePutinTypeEnum;
            }
        }
        return null;
    }

}
