package com.bxm.adsmanager.model.enums;

/**
 * 业务状态和ADX百度bes状态对应枚举
 * Created by zhengwangeng on 2019/8/2.
 */
public enum BesStatusEnum {

    //业务状态：0：审核通过；1：审核中；2：审核拒绝；
    //百度资质审核状态：2：通过；4：拒绝；6：待审

    PASS(0, 2, "审核通过"),
    PENDING(1, 6, "审核中"),
    REFUSE(2, 4, "审核拒绝");

    private int logicStatus;

    private int besAuditResultStatus;

    private String desc;

    BesStatusEnum(int logicStatus, int besAuditResultStatus, String desc) {
        this.logicStatus = logicStatus;
        this.besAuditResultStatus = besAuditResultStatus;
        this.desc = desc;
    }

    public int getLogicStatus() {
        return logicStatus;
    }

    public int getBesAuditResultStatus() {
        return besAuditResultStatus;
    }

    public String getDesc() {
        return desc;
    }

    public static BesStatusEnum getByLogicStatus(int logicStatus) {
        for (BesStatusEnum anEnum : BesStatusEnum.values()) {
            if (anEnum.getLogicStatus() == logicStatus) {
                return anEnum;
            }
        }
        return null;
    }

    public static BesStatusEnum getByBesAuditResultStatus(int besAuditResultStatus) {
        for (BesStatusEnum anEnum : BesStatusEnum.values()) {
            if (anEnum.getBesAuditResultStatus() == besAuditResultStatus) {
                return anEnum;
            }
        }
        return null;
    }

}
