/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the
 * confidential and proprietary information of bianxianmao.com ("Confidential
 * Information"). You shall not disclose such Confidential Information and shall
 * use it only in accordance with the terms of the license agreement you entered
 * into with bianxianmao.com.
 */

package com.bxm.adsmanager.model.enums;

/**
 * <h3>城市code对应老系统城市名</h3>
 * <p></p>
 *
 * @author hcmony
 * @since V1.0.0, 2018/01/09 12:59
 */
public enum CitysEnum {

    SHANGHAISHI("310000", "上海省"),
    SHANGHAISHENG("310100", "上海市"),
    HANGZHOUSHI("330100", "杭州市"),
    BEIJINGSHI("110100", "北京市"),// 110100  110200
    GUANGZHOUSHI("440100", "广州市"),
    QITAIHESHI("230900", "七台河市"),
    SANYASHI("460200", "三亚市"),
    SANMINGSHI("350400", "三明市"),
    SANSHASHI("610422", "三沙市"),
    SANMENXIASHI("411200", "三门峡市"),
    SHANGRAOSHI("361100", "上饶市"),// 362300
    DONGGUANSHI("441900", "东莞市"),
    DONGYINGSHI("370500", "东营市"),
    ZONGWEISHI("640500", "中卫市"),
    ZHONGSHANSHI("442000", "中山市"),
    LINXIAHUIZUZIZHIZHOU("622900", "临夏回族自治州市"),
    LINFENSHI("141000", "临汾市"),//142600
    LINYISHI("371300", "临沂市"),
    LINCANGSHI("530900", "临沧市"),
    DANDONGSHI("210600", "丹东市"),
    LISHUISHI("331100", "丽水市"),
    LIJIANGSHI("530700", "丽江市"),
    WULANCHABUSHI("150900", "乌兰察布市"),
    WUHAISHI("150300", "乌海市"),
    WULUMUQISHI("650100", "乌鲁木齐市"),
    LESHANSHI("511100", "乐山市"),
    JIUJIANGSHI("360400", "九江市"),
    YUNANSHENG("530000", "云南省"),
    YUNFUSHI("445300", "云浮市"),
    WUJIAQUSHI("659000", "五家渠市"),
    BOZHOUSHI("341600", "亳州市"),
    YICHUNSHI1("230700", "伊春市"),
    YILIHASAKEZIZHIZHOU("654000", "伊犁哈萨克自治州市"),
    FOSHANSHI("440600", "佛山市"),
    JIAMUSISHI("230800", "佳木斯市"),
    BAODINGSHI("130600", "保定市"),//132400  132400
    BAOSHANGSHI("530500", "保山市"),
    XINYANGSHI("411500", "信阳市"),
    KEZILESUKEERZIZHIZHOUSHI("653000", "克孜勒苏柯尔克孜自治州市"),
    KELAMAYISHI("650200", "克拉玛依市"),
    LUANSHI("341500", "六安市"), //342400
    LIUPANSHISHI("520200", "六盘水市"),
    LANZHOUSHI("620100", "兰州市"),
    XINGANMENG("152200", "兴安盟"),
    NEIJIANGSHI("511000", "内江市"),
    MEIMENGGUZIZHIQU("150000", "内蒙古自治区"),
    LIANGSHANYIZUZIZHIZHOUSHI("513400", "凉山彝族自治州市"),
    BAOTOUSHI("150200", "包头市"),
    BEIHAISHI("450500", "北海市"),
    SHIYANSHI("420300", "十堰市"),
    NANJINGSHI("320100", "南京市"),
    NANCHONGSHI("511300", "南充市"),
    NANNINGSHI("450100", "南宁市"),
    NANPINGSHI("350700", "南平市"),
    NANCHANGSHI("360100", "南昌市"),
    NANTONGSHI("320600", "南通市"),
    NANYANGSHI("411300", "南阳市"),
    BOERTALAMENGZIZHIZHOUSHI("652700", "博尔塔拉蒙古自治州市"),
    XIAMENSHI("350200", "厦门市"),
    SHUANGYASHANSHI("230500", "双鸭山市"),
    TAIZHOUSHI("331000", "台州市"),
    TAIWANSHI("710000", "台湾市"),
    HEFEISHI("340100", "合肥市"),
    JIANSHI("360800", "吉安市"),//362400
    JILINSHI("220200", "吉林市"),
    JILINSHENG("220000", "吉林省"),
    TULUFANDIQU("650400", "吐鲁番市"),
    LVLIANGSHI("141100", "吕梁市"),
    WUZHONGSHI("640300", "吴忠市"),
    ZHOUKOUSHI("411600", "周口市"),
    HULUNBERERSHI("150700", "呼伦贝尔市"),
    HUHEHAOTESHI("150100", "呼和浩特市"),
    HETIANDIQU("653200", "和田市"),
    XIANNINGSHI("421200", "咸宁市"),
    XIANYANGSHI("610400", "咸阳市"),
    HAMIDIQU("650500", "哈密市"),
    HAERBINSHI("230100", "哈尔滨市"),
    TANGSHANSHI("130200", "唐山市"),
    SHANGQIUSHI("411400", "商丘市"),
    SHANGLUOSHI("611000", "商洛市"),
    GESHENSHI("653100", "喀什市"),
    JIAXINGSHI("330400", "嘉兴市"),
    JIAYUGUANSHI("620200", "嘉峪关市"),
    SICHUANSHENG("510000", "四川省"),
    SIPINGSHI("220300", "四平市"),
    GUYUANSHI("640400", "固原市"),
    TUMUSHUKESHI("659000", "图木舒克市"),
    TACHEGNSHI("654200", "塔城市"),
    DAXINGANLINGSHI("232700", "大兴安岭市"),
    DATONGSHI("140200", "大同市"),
    DAQINGSHI("230600", "大庆市"),
    DALIBAIZUZIZHIZHOUSHI("532900", "大理白族自治州市"),
    DALIANSHI("210200", "大连市"),
    TIANSHUISHI("620500", "天水市"),
    TIANJINSHI("120100", "天津市"),//120100 120200
    TAIYUANSHI("140100", "太原市"),
    WEIHAISHI("371000", "威海市"),
    LOUDISHI("431300", "娄底市"),
    XIAOGANSHI("420900", "孝感市"),
    NINGXIAHUIZUZIZHIQU("640000", "宁夏回族自治区"),
    NINGDESHI("350900", "宁德市"),
    NINGBOSHI("330200", "宁波市"),
    ANQIGNSHI("340800", "安庆市"),
    ANKANGSHI("610900", "安康市"),
    ANHUISHENG("340000", "安徽省"),
    ANYANGSHI("410500", "安阳市"),
    ANSHUNSHI("520400", "安顺市"),
    DINGXISHI("621100", "定西市"),
    YIBINSHI("511500", "宜宾市"),
    YICHANGSHI("420500", "宜昌市"),
    YICHUNSHI("360900", "宜春市"),//362200
    BAOJISHI("610300", "宝鸡市"),
    XUANCHENGSHI("341800", "宣城市"), //342500
    SUZHOUSHI("341300", "宿州市"),//342200
    SUQIANSHI("321300", "宿迁市"),
    SHANDONGSHENG("370000", "山东省"),
    SHANNANDIQU("540500", "山南市"),
    SGANXISHENG("140000", "山西省"),
    YUEYANGSHI("430600", "岳阳市"),
    CHONGZUOSHI("451400", "崇左市"),
    BAZHONGSHI("511900", "巴中市"),
    BAYANNAOERSHI("150800", "巴彦淖尔市"),
    BAYINGUOLENGMENGGUZIZHIZHOUSHI("652800", "巴音郭楞蒙古自治州市"),
    CHANGZHOUSHI("320400", "常州市"),
    CHANGDESHI("430700", "常德市"),
    PINGLIANGHSI("620800", "平凉市"),
    PINGDINGSHANSHI("410400", "平顶山市"),
    GUANGDONGSHEN("440000", "广东省"),
    GUANGYUANSHI("510800", "广元市"),
    GUANGANSHI("511600", "广安市"),
    GUANGXIZHUANGZUSHI("450000", "广西壮族市"),
    QIGNYANSHI("621000", "庆阳市"),
    LANGFANGSHI("131000", "廊坊市"),
    YANANSHI("610600", "延安市"),
    YANBIANCHAOXIANZIZHIZHOUSHI("222400", "延边朝鲜族自治州市"),
    KAIFENGSHI("410200", "开封市"),
    ZHANGJIAKOUSHI("130700", "张家口市"),
    ZHANGJIAJIESHI("430800", "张家界市"),
    ZHANGYESHI("620700", "张掖市"),
    XUZHOUSHI("320300", "徐州市"),
    DEHONGDAIZUZIZHIZHOUSHI("533100", "德宏傣族景颇族自治州市"),
    DEZHOUSHI("371400", "德州市"),
    DEYANGSHI("510600", "德阳市"),
    YIZHOUSHI("140900", "忻州市"),//142200
    HUAIHUASHI("431200", "怀化市"),
    NVJIANGLISUZUZIZHIZHOUSHI("533300", "怒江傈僳族自治州市"),
    ENSHITUJIZZUMIAOZUZIZHIZHOUSHI("422800", "恩施土家族苗族自治州市"),
    HUIZHOUSHI("441300", "惠州市"),
    CHENGDUSHI("510100", "成都市"),
    YANGZHOUSHI("321000", "扬州市"),
    CHENGDESHI("130800", "承德市"),
    FUZHOUSHI("361000", "抚州市"), // 362500
    FUSHUNSHI("210400", "抚顺市"),
    LASASHI("540100", "拉萨市"),
    JIEYANGSHI("445200", "揭阳市"),
    PANZHIHUASHI("510400", "攀枝花市"),
    WENSHANSHI("532600", "文山壮族苗族自治州市"),
    XINGXIANGSHI("410700", "新乡市"),
    XINYUSHI("360500", "新余市"),
    XINJIANGWEIWUERZIZHIQU("650000", "新疆维吾尔自治区"),
    WUXISHI("320200", "无锡市"),
    RIGEZEDIQU("540200", "日喀则市"),
    RIZHAOSHI("371100", "日照市"),
    KUNMINGSHI("530100", "昆明市"),
    CHANGJIHUIZUZIZHIZHOUSHI("652300", "昌吉回族自治州市"),
    CHANGDUDIQU("540300", "昌都市"),
    ZHAOTONGSHI("530600", "昭通市"),
    JINZHONGSHI("140700", "晋中市"),
    JINCHENGSHI("140500", "晋城市"),
    PUERSHI("530800", "普洱市"),
    JINGDEZHENSHI("360200", "景德镇市"),
    QUJINGSHI("530300", "曲靖市"),
    SUOZHOUSHI("140600", "朔州市"),
    CHAOYANGSHI("211300", "朝阳市"),
    BENXISHI("210500", "本溪市"),
    LAIBINGSHI("451300", "来宾市"),
    SONGYUANSHI("220700", "松原市"),
    LINZHIDIQU("540400", "林芝市"),
    GUOLUOZANGZUZIZHIZHOUSHI("632600", "果洛藏族自治州市"),
    ZAOZHUANGSHI("370400", "枣庄市"),
    LIUZHOUHSI("450200", "柳州市"),
    ZHUZHOUSHI("430200", "株洲市"),
    GUILINSHI("450300", "桂林市"),
    MEISHOUSHI("441400", "梅州市"),
    WUZHOUSHI("450400", "梧州市"),
    CHUXIONGYIZUZIZHIZHOUSHI("532300", "楚雄彝族自治州市"),
    YULINSHI("610800", "榆林市"),
    WUWEISHI("620600", "武威市"),
    WUHANSHI("420100", "武汉市"),
    BIJISHI("520500", "毕节市"),
    YONGZHOUSHI("431100", "永州市"),
    HANZHONGSHI("610700", "汉中市"),
    SHANTOUSHI("440500", "汕头市"),
    SHANWEISHI("441500", "汕尾市"),
    JIANGSUSHENG("320000", "江苏省"),
    JIANGXISHENG("360000", "江西省"),
    JIANGMENSHI("440700", "江门市"),
    CHIZHOUSHI("341700", "池州市"),//342900
    SHENYANGSHI("210100", "沈阳市"),
    HEBEISHENG("130000", "河北省"),
    HENANSHENG("410000", "河南省"),
    KECHISHI("451200", "河池市"),
    HEYUANSHI("441600", "河源市"),
    QUANZHOUSHI("350500", "泉州市"),
    TAIANSHI("370900", "泰安市"),
    TAIZHOUSHI1("321200", "泰州市"),
    LUZHOUSHI("510500", "泸州市"),
    LUOYANSHI("410300", "洛阳市"),
    JINANSHI("370100", "济南市"),
    JININGSHI("370800", "济宁市"),
    ZHEJIANGSHENG("330000", "浙江省"),
    HAIDONGDIQU("632100", "海东地区"),
    HAIBEIZANGZUZIZHOUSHI("632200", "海北藏族自治州市"),
    HAINANSHENG("460000", "海南省"),
    HAINANZIZHIZHOUSHI("632500", "海南藏族自治州市"),
    HAIKOUSHI("460100", "海口市"),
    HAIXIMENGGUZIZHIZHOUSHI("632800", "海西蒙古族藏族自治州市"),
    ZIBOSHI("370300", "淄博市"),
    HUAIBEISHI("340600", "淮北市"),
    HUAINANSHI("340400", "淮南市"),
    HUANANSHI("320800", "淮安市"),
    SHENZHENSHI("440300", "深圳市"),
    QINGYUANSHI("441800", "清远市"),
    WENZHOUSHI("330300", "温州市"),
    WEINANSHI("610500", "渭南市"),
    HUBEISHENG("420000", "湖北省"),
    HUNANSHENG("430000", "湖南省"),
    HUZHOUSHI("330500", "湖州市"),
    XIANGTANSHI("430300", "湘潭市"),
    XIANGXITUJIAZUZIZHIZHOUSHI("433100", "湘西土家族苗族自治州市"),
    ZHANJIANGSHI("440800", "湛江市"),
    QUZHOUSHI("341100", "滁州市"),
    BIZHOUSHI("371600", "滨州市"),
    LUOHESHI("411100", "漯河市"),
    ZHANGZHOUSHI("350600", "漳州市"),
    WEIFANGSHI("370700", "潍坊市"),
    CHAOZHOUSHI("445100", "潮州市"),
    AOMEN("820000", "澳门特别行政区"),
    PUYANGSHI("410900", "濮阳市"),
    YANTAISHI("370600", "烟台市"),
    JIAOZUOSHI("410800", "焦作市"),
    MUDANJIANGSHI("231000", "牡丹江市"),
    YULINSHI1("450900", "玉林市"),
    YUSHUZANGZUZIZHIZHOUSHI("632700", "玉树藏族自治州市"),
    YUXISHI("530400", "玉溪市"),
    ZHUHAISHI("440400", "珠海市"),
    GANANZANGZUZIZHIZHOUSHI("623000", "甘南藏族自治州市"),
    GANZIZANGZUZIZHIZHOUSHI("513300", "甘孜藏族自治州市"),
    GANSUSHENG("620000", "甘肃省"),
    BAICHEGNSHI("220800", "白城市"),
    HUNSHANGSHI("220600", "白山市"),//浑山市
    BAIQINSHI("620400", "白银市"),
    BAISESHI("451000", "百色市"),
    YIYANSHI("430900", "益阳市"),
    YANCHEGNSHI("320900", "盐城市"),
    PANJINGSHI("211100", "盘锦市"),
    MEISHANGSHI("511400", "眉山市"),
    SHIZUISHANSHI("640200", "石嘴山市"),
    SHIJIAZHUANGSHI("130100", "石家庄市"),
    SHENGNONGJIA("422900", "神农架"),
    FUZHOUHSI("350100", "福州市"),
    FUJIANSHENG("350000", "福建省"),
    QINHUANDANSHI("130300", "秦皇岛市"),
    HONGHEHANSHI("532500", "红河哈尼族彝族自治州市"),
    SHAOXINGSHI("330600", "绍兴市"),
    SUIHUAHSI("232300", "绥化市"),
    MIANYANGSHI("510700", "绵阳市"),
    LIAOCHENGSHI("371500", "聊城市"),
    ZHAOQIGNSHI("441200", "肇庆市"),
    ZIGOGNGSHI("510300", "自贡市"),
    ZHOUSHANSHI("330900", "舟山市"),
    WUHUSHI("340200", "芜湖市"),
    SUZHOUSHI1("320500", "苏州市"),
    MAOMINGSHI("440900", "茂名市"),
    JINZHOUSHI("421000", "荆州市"),
    JINMENSHI("420800", "荆门市"),
    HEZESHI("371700", "荷泽市"),
    PUTIANSHI("350300", "莆田市"),
    LAIWUSHI("371200", "莱芜市"),
    PINGXIANGSHI("360300", "萍乡市"),
    YINGKOUSHI("210800", "营口市"),
    HULUDAOSHI("211400", "葫芦岛市"),//锦西市
    BENGBUSHI("340300", "蚌埠市"),
    HENGSHUIHSI("131100", "衡水市"),
    HENGYANSHI("430400", "衡阳市"),
    QUZHOUSHI1("330800", "衢州市"),
    XIANGYANGSHI("420600", "襄阳市"),
    XISHUANGBANNASHI("532800", "西双版纳傣族自治州市"),
    XININGSHI("630100", "西宁市"),
    XIANSHI("610100", "西安市"),
    XIZANGSHI("540000", "西藏市"),
    XUCHANGSHI("411000", "许昌市"),
    GUZHOUSHENG("520000", "贵州省"),
    GUIGANGHSI("450800", "贵港市"),
    GUIYANGHSI("520100", "贵阳市"),
    HEZHOUSHI("451100", "贺州市"),
    ZIYANGHSI("512000", "资阳市"),
    GANZHOUSHI("360700", "赣州市"),//362100
    CHIFENGSHI("150400", "赤峰市"),
    LIAONINGSHENG("210000", "辽宁省"),
    LIAOYUANSHI("220400", "辽源市"),
    LIAOYANGSHI("211000", "辽阳市"),
    DAZHOUSHI("511700", "达州市"),
    YUNCHENGSHI("140800", "运城市"),//142700
    LIANYUNGANGSHI("320700", "连云港市"),
    DIQINGZIZHISHOUHSI("533400", "迪庆藏族自治州市"),
    TONGHUASHI("220500", "通化市"),
    TONGLIAOSHI("150500", "通辽市"),//哲里木盟 150500
    SUININGSHI("510900", "遂宁市"),
    ZUNYISHI("520300", "遵义市"),
    XINGTAISHI("130500", "邢台市"),
    NAQUSHI("542400", "那曲市"),
    HANDANSHI("130400", "邯郸市"),
    SHAOYANGSHI("430500", "邵阳市"),
    ZHOUZHOUHSI("410100", "郑州市"),
    BINGZHOUSHI("431000", "郴州市"),
    EERDUOSISHI("150600", "鄂尔多斯市"),//伊克昭盟 150600
    EZHOUSHI("420700", "鄂州市"),
    JIUQUANSHI("620900", "酒泉市"),
    CHONGQINGSHENG("500000", "重庆省"),
    CHONGQINGSHI("500100", "重庆市"),
    JINHUASHI("330700", "金华市"),
    QINZHOUSHI("450700", "钦州市"),
    TIELINGSHI("211200", "铁岭市"),
    TONGRENSHI("520600", "铜仁市"),
    TONGCHUANGSHI("610200", "铜川市"),
    TONGLINSHI("340700", "铜陵市"),
    YINCHUANSHI("640100", "银川市"),
    XILINGUOLEMENG("152500", "锡林郭勒盟"),
    JINGZHOUSHI("210700", "锦州市"),
    ZHENJIANGSHI("321100", "镇江市"),
    CHANGCHUNSHI("220100", "长春市"),
    CHANGSHASHI("430100", "长沙市"),
    CHAGNZHISHI("140400", "长治市"),
    FUXINSHI("210900", "阜新市"),
    FUYANGHSI("341200", "阜阳市"),
    FANGCHENGGANGSHI("450600", "防城港市"),
    YANGJIANGSHI("441700", "阳江市"),
    YANGQUANSHI("140300", "阳泉市"),
    AKESUHSI("652900", "阿克苏市"),
    ALETAISHI("654300", "阿勒泰市"),
    ABEIZANGZUZIZHIZHOUSHI("513200", "阿坝藏族羌族自治州市"),
    ALASHANMENG("152900", "阿拉善盟"),
    ALIERSHI("659000", "阿拉尔市"),
    ALIDIQU("542500", "阿里市"),
    LONGNAGHSI("621200", "陇南市"),
    SHANXISHENG("610000", "陕西省"),
    SUIZHOUSHI("421300", "随州市"),
    YAANSHI("511800", "雅安市"),
    QIGNDAOSHI("370200", "青岛市"),
    QINGHAISHENG("630000", "青海省"),
    ANSHANSHI("210300", "鞍山市"),
    SHANGUANSHI("440200", "韶关市"),
    XIANGGANG("810000", "香港特别行政区"),
    ZHUMADIANSHI("411700", "驻马店市"),
    MAANSHANSHI("340500", "马鞍山市"),
    JIXISHI("230300", "鸡西市"),
    HEBISHI("410600", "鹤壁市"),
    HEGANGSHI("230400", "鹤岗市"),
    YINGTANSHI("360600", "鹰潭市"),
    HUANGGANGSHI("421100", "黄冈市"),
    HUANGNANZIZHIZHOUSHI("632300", "黄南藏族自治州市"),
    HUANGSHANSHI("341000", "黄山市"),
    HUANGSHISHI("420200", "黄石市"),
    HEIHESHI("231100", "黑河市"),
    HEILONGJIANGSHENG("230000", "黑龙江省"),
    QIANDONGNANZIZHIZHOUSHI("522600", "黔东南苗族侗族自治州市"),
    QIANNANBUYIZIZHIZHOUSHI("522700", "黔南布依族苗族自治州市"),
    QIANXINANBUYIZIZHIZHOUSHI("522300", "黔西南布依族苗族自治州市"),
    QIQIHAERSHI("230200", "齐齐哈尔市"),
    SONGHUAJIANGDIQU("232100", "松花江地区"),
    LINYEXITONG("232500", "林业系统"),
    WANXIANSHI("511200", "万县市"),
    SHIHEZISHI("659000", "石河子市"),
    ALETAIDIQU("654300", "阿勒泰地区"),
    TACHENGDIQU("654200", "塔城地区"),
    GESHENDIQU("653100", "喀什地区"),
    AKESUDIQU("652900", "阿克苏地区"),
    LEDUQU("630202", "乐都区"),
    JINCHANGSHI("620300", "金昌市"),
    WUZHISHANSHI("469000", "五指山市"),
    LIANCHEGNXIAN("352627", "连城县"),
    LONGYANSHI("350800", "龙岩市"),
    CANGZHOUSHI("130900", "沧州市"),
    XIANTAOSHI("422900", "仙桃市"),
    JIYUANSHI("419000", "济源市"),
    CHAOHUSHI("341400", "巢湖市"), //342600  老系统没有
    LINQUANSHI("342122", "临泉县");


    private String code;
    private String name;

    CitysEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public String getName() {
        return name;
    }

    public static String getNameByCode(String code) {
        for (CitysEnum temp : CitysEnum.values()) {
            if (temp.code.equals(code)) {
                return temp.name;
            }
        }
        return null;
    }

    public static String getCodeByName(String name) {
        for (CitysEnum temp : CitysEnum.values()) {
            if (temp.name.equals(name)) {
                return temp.code;
            }
        }
        return null;
    }

    public static String getCodeByUNName(String name) {
        StringBuffer sb = new StringBuffer();
        for (CitysEnum temp : CitysEnum.values()) {
            if (temp.name.equals(name)) {
                continue;
            } else {
                sb.append(temp.code).append(",");
            }
        }
        return sb.toString();
    }

}
