package com.bxm.adsmanager.model.enums;

import org.apache.commons.lang.StringUtils;

/**
 * @author wangchao
 * @Title:EnvironmentEnum.java
 * @Package:com.bxm.adsmanager.model.enums
 * @Description: 报警提醒使用
 * @date:2018年10月10日 下午3:58:40
 */
public enum EnvironmentEnum {

    OS_ANDROID("appos-1", "android"), OS_IOS("appos-2", "ios"), OS_WEB("appos-3", "web"), OS_OTHER("appos-4", "系统-其他"),

    UA_OTHER("ua-0", "UA-其他"), UA_WEICHAT("ua-1", "微信"), UA_ALIPAY("ua-2", "支付宝");

    private String value;

    private String name;

    private EnvironmentEnum(String value, String name) {
        this.value = value;
        this.name = name;
    }

    public String getValue() {
        return value;
    }

    public String getName() {
        return name;
    }

    public static String getEnvironmentEnumByValue(String value) {
        if (value != null) {
            for (EnvironmentEnum environmentEnum : EnvironmentEnum.values()) {
                if (StringUtils.equals(value, environmentEnum.getValue())) {
                    return environmentEnum.getName();
                }
            }
        }
        return null;
    }
}
