package com.bxm.adsmanager.model.enums;

import org.apache.commons.lang3.StringUtils;

/**
 * 文 件 名 :
 * CopyRright (c) 2008-xxxx:
 * 文件编号：
 * 创 建 人： hxpeng
 * 日 期： 2018/7/17 10:58
 * 修 改 人：
 * 日 期：
 * 描 述： 落地页用户数据年龄段枚举
 * 版 本 号： v1
 */
public enum LandUserAgeRangeEnum {

    /**
     * 青少年
     */
    youngsters(0, "<18"),

    /**
     * 青少年-青年
     */
    youth(1, "18-22"),

    /**
     * 中年-老年
     */
    midlife(2, "22-50"),

    /**
     * 老年
     */
    old(3, ">50");

    private Integer ageRange;
    private String ageDesc;

    LandUserAgeRangeEnum(Integer ageRange, String ageDesc) {
        this.ageRange = ageRange;
        this.ageDesc = ageDesc;
    }

    public Integer getAgeRange() {
        return ageRange;
    }

    public String getAgeDesc() {
        return ageDesc;
    }

    public static String getDesc(Integer ageRange) {
        if (null == ageRange) {
            return "";
        }
        for (LandUserAgeRangeEnum ageRangeEnum : values()) {
            if (ageRangeEnum.getAgeRange().equals(ageRange)) {
                return ageRangeEnum.getAgeDesc();
            }
        }
        return "";
    }

    public static Integer getRange(String desc) {
        if (StringUtils.isBlank(desc)) {
            return null;
        }
        for (LandUserAgeRangeEnum ageRangeEnum : values()) {
            if (ageRangeEnum.getAgeDesc().equals(desc)) {
                return ageRangeEnum.getAgeRange();
            }
        }
        return null;
    }

    public static Integer getRange(Integer age) {
        if (null == age) {
            return null;
        }
        if (age < 18) {
            return youngsters.getAgeRange();
        }
        if (age < 22) {
            return youth.getAgeRange();
        }
        if (age < 50) {
            return midlife.getAgeRange();
        } else {
            return old.getAgeRange();
        }
    }

}
