package com.bxm.adsmanager.model.enums;

import com.google.common.collect.Lists;
import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

import java.util.List;

/**
 * 海外离线广告结算类型
 *
 * @author zhangdong
 * @date 2022/10/28
 */
@Getter
public enum OverseasOfflinePayTypeEnum {

    /**
     * 点击量结算
     */
    CPC(1, Lists.newArrayList("CPC"), "CPC"),
    CPM(2, Lists.newArrayList("CPM"), "CPM"),
    CPT(3, Lists.newArrayList("CPT"), "CPT"),
    CPI(4, Lists.newArrayList("CPI"), "CPI"),
    CPA(5, Lists.newArrayList("CPA"), "CPA"),
    CPS(6, Lists.newArrayList("CPS"), "CPS"),
    E_CPM(7, Lists.newArrayList("ECPM,E_CPM"), "E_CPM"),
    E_CPC(8, Lists.newArrayList("ECPC,E_CPC"), "E_CPC"),
    OTHER(99,Lists.newArrayList(),"OTHER"),

    ;

    private Integer code;

    private List<String> codeStr;

    private String desc;

    OverseasOfflinePayTypeEnum(Integer code, List<String> codeStr, String desc) {
        this.code = code;
        this.codeStr = codeStr;
        this.desc = desc;
    }

    public static OverseasOfflinePayTypeEnum getEnumByCodeStr(String code) {
        if (StringUtils.isEmpty(code)) {
            return OTHER;
        }
        for (OverseasOfflinePayTypeEnum tmp : OverseasOfflinePayTypeEnum.values()) {
            if (tmp.codeStr.contains(code.toUpperCase())) {
                return tmp;
            }
        }
        return OTHER;
    }

}
