package com.bxm.adsmanager.model.enums;

/**
 * 落地页类型.</br>
 * Created by zhengwangeng on 2021/10/22.
 */
public enum PageTypeEnum {

    //落地页类型，1下载类，2表单类，3deeplink 5.激励浏览
    /**
     * 下载类
     */
    DOWNLOAD((short)1, "下载类"),
    /**
     * 表单类=网页类
     */
    FORM((short)2, "网页类"),
    /**
     * deeplink
     */
    DEEPLINK((short)3, "deeplink"),
    /**
     * 激励浏览
     */
    INSPIRE_BROWSE((short)5, "激励浏览"),
    ;

    private short type;
    private String desc;

    public short getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    PageTypeEnum(short type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static PageTypeEnum getByType(short type) {
        for (PageTypeEnum anEnum : PageTypeEnum.values()) {
            if (anEnum.getType() == type) {
                return anEnum;
            }
        }
        return null;
    }

}
