package com.bxm.adsmanager.model.enums;

/**
 * Adx 平台
 *
 * @author fgf
 * @date 2022/1/20
 **/
public enum PanguAdxEnum {
    /**
     * 变现猫
     */
    BXM((short)0, true),
    /**
     * 百度 Bes
     */
    BAIDU_BES((short)1, false),
    /**
     * bxmadx
     */
    BXM_ADX((short)2, true),
    /**
     * 快手
     */
    KUAI_SHOU((short)3, false),
    /**
     * 多盟
     */
    DOMOB((short)4, false),
    /**
     * 讯飞
     */
    IFLYTEK((short)5, false),
    /**
     * 趣头条
     */
    QTT((short)6, false),
    /**
     * OPPO
     */
    OPPO((short)7, false),
    /**
     * 美团
     */
    MEI_TUAN((short)11, false);
    private short adxType;
    private boolean supportMultipleMedia;

    PanguAdxEnum(short adxType, boolean supportMultipleMedia) {
        this.adxType = adxType;
        this.supportMultipleMedia = supportMultipleMedia;
    }

    public short getAdxType() {
        return adxType;
    }

    public boolean isSupportMultipleMedia() {
        return supportMultipleMedia;
    }

    public static PanguAdxEnum getByAdxType(Short adxType) {
        if (null == adxType) {
            return null;
        }
        for (PanguAdxEnum anEnum : PanguAdxEnum.values()) {
            if (anEnum.getAdxType() == adxType) {
                return anEnum;
            }
        }
        return null;
    }
}
