package com.bxm.adsmanager.model.enums;
/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the
 * confidential and proprietary information of bianxianmao.com ("Confidential
 * Information"). You shall not disclose such Confidential Information and shall
 * use it only in accordance with the terms of the license agreement you entered
 * into with bianxianmao.com.
 */


/**
 * <h3>推送数据到前端枚举类 </h3>
 * <p>详见http://192.168.18.101:8090/pages/viewpage.action?pageId=9568442</p>
 *
 * @author hcmony
 * @since V1.0.0, 2017/12/15 11:34
 */
public enum ProdServiceNameEnum {
    /**
     * 服务名           			参数列表					com.bxm.adsprod.facade.rules.
     * 1 广告券地域规则	  	TICKET_REGION				ticketid				TicketRegionRule
     * 2 广告券广告位规则	 	TICKET_POSITION				ticketid				TicketPositionRule
     * 3 广告券时间段预算规则		TICKET_TIMELINE				ticketid				TicketTimelineRule
     * 4 广告位行业地域规则 	POSITION_DOMAIN_REGION  	positionid domaincode	 PositionDomainRegionRule
     * 5 广告位标签地域规则 	POSITION_TAG_REGION 		positionid tagcode 		PositionTagRegionRule
     * 6 自有产品规则
     * 7 广告券频次规则 		TICKET_TIMES 				ticketid         		TicketTimesRule
     * 8 广告券用户画像评分结果 	TICKET_USER_GRADE 			imei 					UserGrade
     * 9 有效广告券列表 		VALID_TICKETS                     				Ticket[]
     * 10 广告券      		TICKET    					ticketid				Ticket
     * 11 所有广告券 			ALL_TICKETS 									Ticket[]
     * 12 广告券价格配置		TICKET_PRICE 				ticketid 				TICKET_PRICE[]
     * 13 广告券权重手动干预系数 TICKET_MIF  				ticketid  				TicketWeightMif[]
     * 14 CPA广告券消耗 		TICKET_PROFIT_FOR_CPA 							TicketProfitForCpa[]
     * 15 广告主充值余额额度  	ADVERTISER_RECHARGE_BALANCE advertiserid  		String - 本次充值金额，单位：厘
     * 16 广告圈弹窗                  TICKET_SCENE         positionid  scenetype
     * 18 广告组                  TICKET_GROUP         groupid  com.bxm.adsmanager.model.vo.adticketgroup
     * .TicketGroupPushVo
     */


    POSITION_TAG_REGION(1, "广告位标签地域规则", "POSITION_TAG_REGION", "positionid,tagcode"),
    POSITION_DOMAIN_REGION(2, "广告位行业地域规则", "POSITION_DOMAIN_REGION", "positionid,domaincode"),
    TICKET_TIMES(3, "广告券频次规则", "TICKET_TIMES", "ticketid"),
    TICKET_POSITION(4, "广告券广告位规则", "TICKET_POSITION", "ticketid"),
    TICKET_TIMELINE(5, "广告券时间段预算规则", "TICKET_TIMELINE", "ticketid"),
    TICKET_REGION(6, "广告券地域规则", "TICKET_REGION", "ticketid"),

    TICKET_USER_GRADE(8, "广告券用户画像评分结果", "TICKET_USER_GRADE", "imei"),
    VALID_TICKETS(9, "有效广告券列表", "VALID_TICKETS", null),
    TICKET(10, "广告券", "TICKET", "ticketid"),
    ALL_TICKETS(11, "所有广告券", "ALL_TICKETS", null),
    TICKET_PRICE(12, "广告券价格配置", "TICKET_PRICE", "ticketid"),
    TICKET_MIF(13, "广告券权重手动干预系数", "TICKET_MIF", "ticketid"),
    TICKET_PROFIT_FOR_CPA(14, "CPA广告券消耗", "TICKET_PROFIT_FOR_CPA", null),
    POSITION(15, "广告位", "POSITION", "positionid"),
    TICKET_SCENE(16, "弹窗", "TICKET_SCENE", "positionid,scenetype"),
    TICKET_WEIGHT(17, "权重", "TICKET_WEIGHT", "ticketid"),
    TICKET_GROUP(18, "广告组", "TICKET_GROUP", "groupid"),
    POSITION_TEST(19, "媒体广告位测试", "POSITION_TEST", "positionId"),
    MEDIA_TAG_REGION_TIME(20, "广告位标签地域时间段黑名单", "MEDIA_TAG_REGION_TIME", null),
    POSITION_GROUP_OLDTONEW(21, "流量包同步数据处理", "POSITION_GROUP_OLDTONEW", null),
    MEDIA_WHITE_TICKET(22, "广告位白名单券", "MEDIA_WHITE_TICKET", null),
    TICKET_IPLIB_REGION(23, "广告券指定IP库限制", "TICKET_IPLIB_REGION", "ticketid"),
    POSITION_CONFIG_CACHEPUSH(24, "广告位配置", "POSITION_CONFIG_CACHEPUSH", null),
    POSITION_DIRECT_TICKET(25, "广告位直投券配置", "POSITION_DIRECT_TICKET", null),
    DIRECT_TICKET_MATERIAL(26, "直投券素材配置", "DIRECT_TICKET_MATERIAL", null),
    STATION_USER_WEIGHT(27, "站内户权重计划", "STATION_USER_WEIGHT", null),
    DIY_SITE_INFO(28, "自建站落地页信息", "DIY_SITE_INFO", null),

    THIRD_PARTY_CROWD_PACKAGE(29, "第三方人群包", "THIRD_PARTY_CROWD_PACKAGE", null),
    TICKET_PACKAGE(30, "ADX券出券券包", "TICKET_PACKAGE", null),
    APP_PACKAGE(31, "App包名定向", "APP_PACKAGE", null),

    RIGHTS(32, "权益奖品", "RIGHTS", null),
    ISP(33, "运营商", "ISP", null),

    NETWORK_TYPE(34, "网络类型", "NETWORK_TYPE", null),
    AD_QUALITY(35, "广告位质量", "AD_QUALITY", null),
    ACTIVITY_ORIENTATION(36, "活动定向", "ACTIVITY_ORIENTATION", null),

    MEDIA_APP_PACKAGE(37, "媒体App包名定向", "MEDIA_APP_PACKAGE", null),

    ASSETS_TEMPLATE(38, "素材模板", "ASSETS_TEMPLATE", null),
    NEW_AND_OLD_USERS(39, "新老用户定向", "NEW_AND_OLD_USERS", null),
    GETUI_SEX(40, "个推性别定向", "GETUI_SEX", null),
    ADX_APP_ID(41, "ADX AppID定向", "ADX_APP_ID", null),

    BES_GENDER(42, "百度性别定向", "BES_GENDER", null),
    BES_AGE(43, "百度年龄定向", "BES_AGE", null),
    ADX_ENTRANCE(44, "常规券ADX流量入口定向", "ADX_ENTRANCE", null),

    DOWNLOAD_LANDING_PAGE(45, "下载类落地页", "DOWNLOAD_LANDING_PAGE", null),
    ACTIVITY_TICKET_BLACK(46, "活动广告券定向", "ACTIVITY_TICKET_BLACK", null),

    ASSETS_CONFIG_UID(47, "ADX广告素材强出配置", "ASSETS_CONFIG_UID", null),
    POSITION_APP_ID_BLACK(48, "广告位appId黑名单", "POSITION_APP_ID_BLACK", null),

    PHONE_BRAND(49, "手机品牌", "PHONE_BRAND", null),
    GROUP_MUTEX_TICKET(50, "互斥券", "GROUP_MUTEX_TICKET", null),
    TIME_BIDDING(51, "广告券时间段出价", "TIME_BIDDING", null),

    APP_ID_PACKAGE(52, "AppId包", "APP_ID_PACKAGE", null),
    ADX_TAG_ID(53, "adx广告位", "ADX_TAG_ID", null),
    GROUP_APPKEY_TICKET(54, "媒体白名单券", "GROUP_APPKEY_TICKET", null),
    TICKET_GROUP_WHITE(55, "广告组白名单券", "TICKET_GROUP_WHITE", "groupid"),
    POSITION_BLACKTAG_HIGHEST_LEVEL(56, "广告位黑名单标签从严屏蔽", "POSITION_BLACKTAG_HIGHEST_LEVEL", null),
    COUNTRY(57, "国家定向", "COUNTRY", null),

    BAIDU_LOOK_LIKE(58, "百度LookLike", "BAIDU_LOOK_LIKE", null),

    MEDIA_POSITION(59, "媒体广告位", "MEDIA_POSITION", null),
    ADVERTISER(60, "广告主", "ADVERTISER", null),
    GROUP_POSITION_SWITCH(61, "广告位白名单组是否开启", "GROUP_POSITION_SWITCH", null),

    TICKET_EXPLORE(62, "加速探索", "TICKET_EXPLORE", null),
    ;


    private int id;
    private String name;
    private String serviceName;
    private String parameters;

    ProdServiceNameEnum(int id, String name, String serviceName, String parameters) {
        this.id = id;
        this.name = name;
        this.serviceName = serviceName;
        this.parameters = parameters;
    }

    public int getId() {
        return id;
    }

    public String getName() {
        return name;
    }

    public String getServiceName() {
        return serviceName;
    }

    public String getParameters() {
        return parameters;
    }

}
