package com.bxm.adsmanager.model.enums;
/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the
 * confidential and proprietary information of bianxianmao.com ("Confidential
 * Information"). You shall not disclose such Confidential Information and shall
 * use it only in accordance with the terms of the license agreement you entered
 * into with bianxianmao.com.
 */


/**
 * <h3> 规则类型 枚举
 *
 * @author hcmony
 * @since V1.0.0, 2017/12/11 20:09
 */
public enum RuleTypeEnum {

    BIAOQIANDIYU(1, "广告位标签地域时间段限制", ProdServiceNameEnum.POSITION_TAG_REGION),
    HANGYEDIYU(2, "广告位行业地域限制", ProdServiceNameEnum.POSITION_DOMAIN_REGION),
    // cycle=周期->天数; type=类型。1- 曝光、2- 点击、3- 请求、4- 开屏请求、5- IP曝光、6- IP点击; count=次数
    PINCI(3, "广告券频次限制", ProdServiceNameEnum.TICKET_TIMES),
    GUANGGAOWEI(4, "广告券广告位黑白名单", ProdServiceNameEnum.TICKET_POSITION),
    SHIJIANDUAN(5, "广告券时间段预算开放", ProdServiceNameEnum.TICKET_TIMELINE),
    DIYUXIANZHI(6, "广告券地域限制", ProdServiceNameEnum.TICKET_REGION),
    FLOWPACKAGE(7, "广告券流量包限制", ProdServiceNameEnum.TICKET_POSITION),
    IPLIB(8, "广告券指定IP库限制", ProdServiceNameEnum.TICKET_IPLIB_REGION),

    THIRD_PARTY_CROWD_PACKAGE(29, "第三方人群包", ProdServiceNameEnum.THIRD_PARTY_CROWD_PACKAGE),
    TICKET_PACKAGE(30, "ADX券出券券包", ProdServiceNameEnum.TICKET_PACKAGE),
    APP_PACKAGE(31, "App包名定向", ProdServiceNameEnum.APP_PACKAGE),
    ISP(33, "运营商", ProdServiceNameEnum.ISP),

    NETWORK_TYPE(34, "网络类型", ProdServiceNameEnum.NETWORK_TYPE),
    AD_QUALITY(35, "广告位质量", ProdServiceNameEnum.AD_QUALITY),
    ACTIVITY_ORIENTATION(36, "活动定向", ProdServiceNameEnum.ACTIVITY_ORIENTATION),

    MEDIA_APP_PACKAGE(37, "媒体App包名定向", ProdServiceNameEnum.APP_PACKAGE),
    NEW_AND_OLD_USERS(38, "新老用户定向", ProdServiceNameEnum.NEW_AND_OLD_USERS),
    GETUI_SEX(39, "个推性别定向", ProdServiceNameEnum.GETUI_SEX),
    ADX_APP_ID(41, "ADX AppID定向", ProdServiceNameEnum.ADX_APP_ID),

    BES_GENDER(42, "百度性别定向", ProdServiceNameEnum.BES_GENDER),
    BES_AGE(43, "百度年龄定向", ProdServiceNameEnum.BES_AGE),
    ADX_ENTRANCE(44, "常规券ADX流量入口定向", ProdServiceNameEnum.ADX_ENTRANCE),

    DOWNLOAD_LANDING_PAGE(45, "下载类落地页", ProdServiceNameEnum.DOWNLOAD_LANDING_PAGE),
    ACTIVITY_TICKET_BLACK(46, "活动广告券定向", ProdServiceNameEnum.ACTIVITY_TICKET_BLACK),

    PHONE_BRAND(49, "手机品牌", ProdServiceNameEnum.PHONE_BRAND),
    TIME_BIDDING(51, "广告券时间段出价", ProdServiceNameEnum.TIME_BIDDING),

    APP_ID_PACKAGE(52, "AppId包定向", ProdServiceNameEnum.APP_ID_PACKAGE),

    ADX_TAG_ID(53, "Adx广告位定向", ProdServiceNameEnum.ADX_TAG_ID),
    COUNTRY(57, "国家定向", ProdServiceNameEnum.COUNTRY),
    BAIDU_LOOK_LIKE(58, "百度looklike定向", ProdServiceNameEnum.BAIDU_LOOK_LIKE),
    ;

    private int value;
    private String name;
    private ProdServiceNameEnum prodServiceNameEnum;

    RuleTypeEnum(int value, String name, ProdServiceNameEnum prodServiceNameEnum) {
        this.value = value;
        this.name = name;
        this.prodServiceNameEnum = prodServiceNameEnum;
    }

    public int getValue() {
        return value;
    }

    public String getName() {
        return name;
    }

    public Enum getProdServiceNameEnum() {
        return prodServiceNameEnum;
    }

    public static String getNameByValue(int value) {
        for (RuleTypeEnum temp : RuleTypeEnum.values()) {
            if (temp.value == value) {
                return temp.name;
            }
        }
        return null;
    }

    public static ProdServiceNameEnum getEnumByValue(int value) {
        for (RuleTypeEnum temp : RuleTypeEnum.values()) {
            if (temp.value == (value)) {
                return temp.prodServiceNameEnum;
            }
        }
        return null;
    }

}
