package com.bxm.adsmanager.model.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * 广告组频次
 *
 * @author 阿导
 * @version 1.0
 * @fileName com.bxm.adsmanager.model.enums.TicketGroupFrequencyEnum.java
 * @CopyRright (c) 2018-杭州微财科技有限公司
 * @created 2018-03-23 09:46:00
 */
public enum TicketGroupFrequencyEnum {
    EVERY_DAY(1, "每天"),
    EVERY_WEEK(2, "每周");
    private Integer code;

    private String name;

    private TicketGroupFrequencyEnum(Integer code, String name) {
        this.code = code;
        this.name = name;
    }

    /**
     * @return the code
     */
    public Integer getCode() {
        return code;
    }

    /**
     * @return the name
     */
    public String getName() {
        return name;
    }


    /**
     * 所有状态
     *
     * @return
     */
    public static Map<Integer, String> getAllState() {
        TicketGroupFrequencyEnum[] sts = TicketGroupFrequencyEnum.values();
        Map<Integer, String> maps = new HashMap<Integer, String>();
        for (TicketGroupFrequencyEnum tmp : sts) {
            maps.put(tmp.code, tmp.name);
        }
        return maps;
    }

    /**
     * 根据code得到name
     *
     * @param code
     * @return
     */
    public static String getName(Integer code) {
        try {
            for (TicketGroupFrequencyEnum state : TicketGroupFrequencyEnum.values()) {
                if (state.getCode().equals(code)) {
                    return state.getName();
                }
            }
        } catch (Exception e) {
            return "";
        }
        return "未找到字典";
    }

}
