package com.bxm.adsmanager.model.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * 广告组状态
 *
 * @author 阿导
 * @version 1.0
 * @fileName com.bxm.adsmanager.model.enums.TicketGroupStatusEnum.java
 * @CopyRright (c) 2018-杭州微财科技有限公司
 * @created 2018-03-23 09:45:00
 */
public enum TicketGroupStatusEnum {

    ON(1, "开启"),
    OFF(0, "关闭");

    private Integer code;

    private String name;

    private TicketGroupStatusEnum(Integer code, String name) {
        this.code = code;
        this.name = name;
    }

    /**
     * @return the code
     */
    public Integer getCode() {
        return code;
    }

    /**
     * @return the name
     */
    public String getName() {
        return name;
    }


    /**
     * 所有状态
     *
     * @return
     */
    public static Map<Integer, String> getAllState() {
        TicketGroupStatusEnum[] sts = TicketGroupStatusEnum.values();
        Map<Integer, String> maps = new HashMap<Integer, String>();
        for (TicketGroupStatusEnum tmp : sts) {
            maps.put(tmp.code, tmp.name);
        }
        return maps;
    }

    /**
     * 根据code得到name
     *
     * @param code
     * @return
     */
    public static String getName(Integer code) {
        try {
            for (TicketGroupStatusEnum state : TicketGroupStatusEnum.values()) {
                if (state.getCode().equals(code)) {
                    return state.getName();
                }
            }
        } catch (Exception e) {
            return "";
        }
        return "未找到字典";
    }

}
