package com.bxm.adsmanager.model.enums;

/**
 * 文 件 名 :
 * CopyRright (c) 2008-xxxx:
 * 文件编号：
 * 创 建 人： hxpeng
 * 日 期： 2018/7/27 14:28
 * 修 改 人：
 * 日 期：
 * 描 述：
 * 版 本 号： v1
 */
public enum TicketPauseReasonEnum {

    /**
     * 今日超出预算
     */
    EXCESS_BUDGET(1, "今日超出预算"),

    /**
     * 余额不足
     */
    BALANCE_NOT_ENOUGH(2, "余额不足"),

    /**
     * 未到投放日期
     */
    NO_TIME_TO_LAUNCH(3, "未到投放日期"),

    /**
     * 投放结束
     */
    LAUNCH_FINISH(4, "投放结束"),

    /**
     * 时段预算不足
     */
    SHORT_PERIOD_BUDGET(5, "时段预算不足"),

    /**
     * 码库存不足
     */
    UNDER_STOCK(6, "码库存不足"),

    /**
     * 其他原因
     */
    OTHER_REASONS(99, "其他原因");

    private Integer code;
    private String desc;

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    TicketPauseReasonEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static TicketPauseReasonEnum getByCode(Integer code) {
        if (null == code) {
            return null;
        }
        for (TicketPauseReasonEnum ticketPauseReasonEnum : TicketPauseReasonEnum.values()) {
            if (ticketPauseReasonEnum.getCode().equals(code)) {
                return ticketPauseReasonEnum;
            }
        }
        return null;
    }
}
