package com.bxm.adsmanager.model.enums;

/**
 * 文 件 名 :
 * CopyRright (c) 2008-xxxx:
 * 文件编号：
 * 创 建 人： hxpeng
 * 日 期： 2018/7/27 14:20
 * 修 改 人：
 * 日 期：
 * 描 述： 券状态枚举类
 * 版 本 号： v1
 */
public enum TicketStatusEnum {

    /**
     * 正常
     */
    NORMAL(1, "正常"),
    /**
     * 暂停
     */
    PAUSE(2, "暂停"),
    /**
     * 停止
     */
    STOP(3, "停止"),
    /**
     * 已删除
     */
    DELETED(99, "已删除"),
    /**
     * 待审核状态
     */
    WAIT_EXAMINE(-2, "待审核状态"),
    /**
     * 待优化状态
     */
    WAIT_OPTIMIZATION(-1, "待优化状态"),
    /**
     * 审核拒绝状态
     */
    AUDIT_REJECTION(-3, "审核拒绝状态");


    private Integer status;
    private String desc;

    public Integer getStatus() {
        return status;
    }

    public String getDesc() {
        return desc;
    }

    TicketStatusEnum(Integer status, String desc) {
        this.status = status;
        this.desc = desc;
    }

    public static TicketStatusEnum getByStatus(Integer status) {
        if (null == status) {
            return null;
        }
        for (TicketStatusEnum ticketStatusEnum : TicketStatusEnum.values()) {
            if (ticketStatusEnum.getStatus().equals(status)) {
                return ticketStatusEnum;
            }
        }
        return null;
    }

}
