package com.bxm.adsmanager.model.ro;

import java.math.BigDecimal;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import com.bxm.adsmanager.model.base.BaseModel;

import io.swagger.annotations.ApiModelProperty;

/**
 * @author yirenjie
 * createDate:  2018/7/17
 */
public class AppEntranceEditRo extends BaseModel {

    /**
     * 主键id
     */
    @ApiModelProperty(value = "id")
    private Long id;

    /**
     * 备注
     */
    @ApiModelProperty(value = "备注")
    private String remark;

    /**
     * 别名
     */
    @ApiModelProperty(value = "别名")
    private String alias;

    /**
     * 媒体分类
     */
    @ApiModelProperty(value = "媒体分类")
    private String mediaClass;

    /**
     * 媒体子分类
     */
    @ApiModelProperty(value = "媒体子分类")
    private String mediaChildClass;

    @ApiModelProperty(value = "广告位类型, 信息流:INFORMATION_FLOW,非信息流:NON_INFORMATION_FLOW")
    private String positionType; // 广告位类型
    private String appKey;  // appKey
    private String business;// positionId,可与appKey组合为adPositionId
    private Integer config = 0;// .0为客服不前置,76为客服前置
    //合作类型（1 分成、2 采买、3 RTB）
    private Byte cooperationType;
    private Byte newWanliu;//新增挽留（默认前置）

    /**
     * 广告位挽留弹窗开启地域，以逗号分隔
     */
    private String stayWindowdsRegion;

    /**
     * 广告位挽留弹窗开启时段，以逗号分隔
     */
    private String stayWindowdsTime;

    private Byte more;//更多精彩（默认前置）
    private Byte activityStatement;//活动声明（0-默认不前置,1-底部前置，2-顶部前置）
    private String intro;//活动声明说明
    private Byte rewardTicket =0;// 激励券是否开启(0不开启 1开启)
    private String actRule;  //活动规则
    private String actExplain;  //活动说明

    private Byte qqFront =1;// qq是否开启前置(0不开启 1开启) 默认开启
    private String qq;
    private String kfPhone;  //客服号码
    private String positionIds;

    private Byte checkUv = 0;// 是否过滤uv<100 （0 过滤 1不过滤）
    
    private Integer rewardTicketCount; //激励券开启数量
    private Byte dockingMethod ;


    private Integer openWhiteGroup  = 1; // 1是开启，其他都是关闭，默认是开启
    /**
     * 浮标素材是否前置：
     * 0不前置，1-前置
     */
    private Integer needFloatMaterial;
    
     /**
     * 广告位尺寸
     */
    @ApiModelProperty(value = "广告位尺寸")
    private String positionSize;
    
    /**
     * 客户类型 0:直客 1:代理
     */
    private Integer accountType;

    /**
     * 是否dsp
     */
    private Boolean dspFlag;

    /**
     * 广告入口场景 = 素材类型
     */
    private String entranceScene;

    /**
     * 开发者应用别名， 广告位别名
     */
    private String providerAlias;
    private String appEntranceAlias;

    @ApiModelProperty(value = "券码投放?0:关闭，1:开启 ？true开启， false 关闭")
    private Boolean couponsPutinFlag;

    @ApiModelProperty(value = "券码投放浮标位尺寸ID")
    private Long couponsIconSize;

    @ApiModelProperty(value = "券码投放展示位尺寸ID")
    private Long couponsCreativeSize;

    @ApiModelProperty(value = "投放方式类型：1常规投放，2券码类投放，3激励视频投放")
    private Byte putinType;

    @ApiModelProperty(value = "视频方向：1横版，2竖板")
    private Byte videoDirection;

    @ApiModelProperty(value = "上报地址")
    private String reportUrl;

    private AdxConf adxConf; //ADX互动/ADX直投 配置信息

    private Byte positionScene; // 广告位场景

    /**
     * 小程序投放0:关闭，1:开启
     */
    private Boolean wechatMiniAppPutFlag;
    
    /**
     * 所属国家
     */
    private String country;

    public Byte getQqFront() {
        return qqFront;
    }

    public void setQqFront(Byte qqFront) {
        this.qqFront = qqFront;
    }

    public String getQq() {
        return qq;
    }

    public Integer getOpenWhiteGroup() {
        return openWhiteGroup;
    }

    public void setOpenWhiteGroup(Integer openWhiteGroup) {
        this.openWhiteGroup = openWhiteGroup;
    }

    public void setQq(String qq) {
        this.qq = qq;
    }

    public String getKfPhone() {
        return kfPhone;
    }

    public void setKfPhone(String kfPhone) {
        this.kfPhone = kfPhone;
    }

    public String getPositionIds() {
        return positionIds;
    }

    public void setPositionIds(String positionIds) {
        this.positionIds = positionIds;
    }

    public String getCountry() {
        return country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public Byte getCheckUv() {
        return checkUv;
    }

    public void setCheckUv(Byte checkUv) {
        this.checkUv = checkUv;
    }

    public Byte getPutinType() {
        return putinType;
    }

    public void setPutinType(Byte putinType) {
        this.putinType = putinType;
    }

    public Byte getVideoDirection() {
        return videoDirection;
    }

    public void setVideoDirection(Byte videoDirection) {
        this.videoDirection = videoDirection;
    }

    public String getReportUrl() {
        return reportUrl;
    }

    public void setReportUrl(String reportUrl) {
        this.reportUrl = reportUrl;
    }

    public static class AdxConf {
        /**
         * 广告位ADX类型
         * @see com.bxm.adsmedia.model.enums.AppEntranceAdxAdTypeEnum
         */
        private String adType;

        /**
         * 广告位场景类型
         * @see com.bxm.adsmedia.model.enums.AppEntranceAdxPositionTypeEnum
         */
        private Short positionType;

        /**
         * 广告位类型的描述：多图文、单图文等
         */
        private String positionTypeDesc;

        /**
         * 正常流量占比，单位：百分比
         */
        private Integer normalRequestsRatio;

        /**
         * 结算方式：1- CPC、2-CPA、3-OCPC、4-CPM
         */
        private Short settleType;

        /**
         * ADX渠道：1-搜狗
         */
        private Short adxChannel;

        /**
         * ADX渠道广告位TagId
         */
        private String channelTagId;

        /**
         * 最低出价，单位为厘
         */
        private String minimumPrice;

        /**
         * 素材模版Id
         */
        private String assetsTemplateId;

        /**
         * 利润率
         */
        private Integer profitMargin;

        private AdxNative adxNative;
        private AdxPicture adxPicture;
        private AdxText adxText;

        /**
         * adx 原生视频广告位信息
         */
        private AdxNativeVideo adxNativeVideo;

        public static class AdxNative {
            /**
             * 标题内容最大长度限制
             */
            private Integer titleMaximumLength;

            /**
             * 文本内容限制。{type}-{maximum_len},{type}-{maximum_len}。type：1- 选填、2- 必填，maximum_len：最大长度限制
             */
            private String contentConstraints;

            /**
             * icon尺寸限制。{type-height-width-maximum_kb}。type：1- 选填、2- 必填，height：高，width：宽，maximum_kb：最大KB限制
             */
            private String iconConstraints;

            /**
             * 图片格式：JPG,JPEG,PNG,GIF
             */
            private String pictureFormats;

            /**
             * 图片尺寸约束。{height-width-maximum_kb},{height-width-maximum_kb}。height：高，width：宽，maximum_kb：KB限制
             */
            private String pictureConstraints;

            public Integer getTitleMaximumLength() {
                return titleMaximumLength;
            }

            public void setTitleMaximumLength(Integer titleMaximumLength) {
                this.titleMaximumLength = titleMaximumLength;
            }

            public String getContentConstraints() {
                return contentConstraints;
            }

            public void setContentConstraints(String contentConstraints) {
                this.contentConstraints = contentConstraints;
            }

            public String getIconConstraints() {
                return iconConstraints;
            }

            public void setIconConstraints(String iconConstraints) {
                this.iconConstraints = iconConstraints;
            }

            public String getPictureFormats() {
                return pictureFormats;
            }

            public void setPictureFormats(String pictureFormats) {
                this.pictureFormats = pictureFormats;
            }

            public String getPictureConstraints() {
                return pictureConstraints;
            }

            public void setPictureConstraints(String pictureConstraints) {
                this.pictureConstraints = pictureConstraints;
            }
        }

        public static class AdxPicture {
            /**
             * 图片格式：JPG,JPEG,PNG,GIF
             */
            private String pictureFormats;

            /**
             * 图片尺寸约束。{height-width-maximum_kb},{height-width-maximum_kb}。height：高，width：宽，maximum_kb：KB限制
             */
            private String pictureConstraints;

            public String getPictureFormats() {
                return pictureFormats;
            }

            public void setPictureFormats(String pictureFormats) {
                this.pictureFormats = pictureFormats;
            }

            public String getPictureConstraints() {
                return pictureConstraints;
            }

            public void setPictureConstraints(String pictureConstraints) {
                this.pictureConstraints = pictureConstraints;
            }
        }

        public static class AdxText {
            /**
             * 标题内容最大长度限制
             */
            private Integer titleMaximumLength;

            /**
             * 文本内容限制。{type}-{maximum_len},{type}-{maximum_len}。type：1- 选填、2- 必填，maximum_len：最大长度限制
             */
            private String contentConstraints;

            public Integer getTitleMaximumLength() {
                return titleMaximumLength;
            }

            public void setTitleMaximumLength(Integer titleMaximumLength) {
                this.titleMaximumLength = titleMaximumLength;
            }

            public String getContentConstraints() {
                return contentConstraints;
            }

            public void setContentConstraints(String contentConstraints) {
                this.contentConstraints = contentConstraints;
            }
        }

        public static class AdxNativeVideo {

            /**
             * 封面图约束 {type-height-width-maximum_kb}。type：1- 选填、2- 必填，height：高，width：宽，maximum_kb：最大KB限制'
             */
            private String coverPictureConstraints;

            /**
             * icon尺寸限制。{type-height-width-maximum_kb}。type：1- 选填、2- 必填，height：高，width：宽，maximum_kb：最大KB限制
             */
            private String iconConstraints;

            /**
             * 大图尺寸限制。{type-height-width-maximum_kb}。type：1- 选填、2- 必填，height：高，width：宽，maximum_kb：最大KB限制'
             */
            private String largeSizeConstraints;

            /**
             * 图片格式：JPG,JPEG,PNG,GIF
             */
            private String pictureFormats;

            /**
             * 标题限制 {type}-{maximum_len},{type}-{maximum_len}。type：1- 选填、2- 必填，maximum_len：最大长度限制'
             */
            private String titleConstraints;


            /**
             * 内容限制。{type}-{maximum_len},{type}-{maximum_len}。type：1- 选填、2- 必填，maximum_len：最大长度限制'
             */
            private String contentConstraints;


            /**
             * 视频尺寸限制 {height-width-maximum_kb}，height：高，width：宽，maximum_kb：最大KB限制
             */
            private String videoSize;

            /**
             * 播放类型 1不限 2 横屏 3 竖屏
             */
            private Byte playType;

            /**
             * 视频格式 存储配置项id 多个以逗号分割
             */
            private String videoFormats;

            public String getCoverPictureConstraints() {
                return coverPictureConstraints;
            }

            public void setCoverPictureConstraints(String coverPictureConstraints) {
                this.coverPictureConstraints = coverPictureConstraints;
            }

            public String getIconConstraints() {
                return iconConstraints;
            }

            public void setIconConstraints(String iconConstraints) {
                this.iconConstraints = iconConstraints;
            }

            public String getLargeSizeConstraints() {
                return largeSizeConstraints;
            }

            public void setLargeSizeConstraints(String largeSizeConstraints) {
                this.largeSizeConstraints = largeSizeConstraints;
            }

            public String getPictureFormats() {
                return pictureFormats;
            }

            public void setPictureFormats(String pictureFormats) {
                this.pictureFormats = pictureFormats;
            }

            public String getTitleConstraints() {
                return titleConstraints;
            }

            public void setTitleConstraints(String titleConstraints) {
                this.titleConstraints = titleConstraints;
            }

            public String getContentConstraints() {
                return contentConstraints;
            }

            public void setContentConstraints(String contentConstraints) {
                this.contentConstraints = contentConstraints;
            }

            public String getVideoSize() {
                return videoSize;
            }

            public void setVideoSize(String videoSize) {
                this.videoSize = videoSize;
            }

            public Byte getPlayType() {
                return playType;
            }

            public void setPlayType(Byte playType) {
                this.playType = playType;
            }

            public String getVideoFormats() {
                return videoFormats;
            }

            public void setVideoFormats(String videoFormats) {
                this.videoFormats = videoFormats;
            }
        }

        public String getAdType() {
            return adType;
        }

        public void setAdType(String adType) {
            this.adType = adType;
        }

        public Short getPositionType() {
            return positionType;
        }

        public void setPositionType(Short positionType) {
            this.positionType = positionType;
        }

        public String getPositionTypeDesc() {
            return positionTypeDesc;
        }

        public void setPositionTypeDesc(String positionTypeDesc) {
            this.positionTypeDesc = positionTypeDesc;
        }

        public Integer getNormalRequestsRatio() {
            return normalRequestsRatio;
        }

        public void setNormalRequestsRatio(Integer normalRequestsRatio) {
            this.normalRequestsRatio = normalRequestsRatio;
        }

        public Short getSettleType() {
            return settleType;
        }

        public void setSettleType(Short settleType) {
            this.settleType = settleType;
        }

        public Short getAdxChannel() {
            return adxChannel;
        }

        public void setAdxChannel(Short adxChannel) {
            this.adxChannel = adxChannel;
        }

        public String getChannelTagId() {
            return channelTagId;
        }

        public void setChannelTagId(String channelTagId) {
            this.channelTagId = channelTagId;
        }

        public String getMinimumPrice() {
            return minimumPrice;
        }

        public void setMinimumPrice(String minimumPrice) {
            this.minimumPrice = minimumPrice;
        }

        public String getAssetsTemplateId() {
            return assetsTemplateId;
        }

        public void setAssetsTemplateId(String assetsTemplateId) {
            this.assetsTemplateId = assetsTemplateId;
        }

        public Integer getProfitMargin() {
            return profitMargin;
        }

        public void setProfitMargin(Integer profitMargin) {
            this.profitMargin = profitMargin;
        }

        public AdxNative getAdxNative() {
            return adxNative;
        }

        public void setAdxNative(AdxNative adxNative) {
            this.adxNative = adxNative;
        }

        public AdxPicture getAdxPicture() {
            return adxPicture;
        }

        public void setAdxPicture(AdxPicture adxPicture) {
            this.adxPicture = adxPicture;
        }

        public AdxText getAdxText() {
            return adxText;
        }

        public void setAdxText(AdxText adxText) {
            this.adxText = adxText;
        }

        public AdxNativeVideo getAdxNativeVideo() {
            return adxNativeVideo;
        }

        public void setAdxNativeVideo(AdxNativeVideo adxNativeVideo) {
            this.adxNativeVideo = adxNativeVideo;
        }
    }

    public AdxConf getAdxConf() {
        return adxConf;
    }

    public void setAdxConf(AdxConf adxConf) {
        this.adxConf = adxConf;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getAlias() {
        return alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getMediaClass() {
        return mediaClass;
    }

    public void setMediaClass(String mediaClass) {
        this.mediaClass = mediaClass;
    }

    public String getMediaChildClass() {
        return mediaChildClass;
    }

    public void setMediaChildClass(String mediaChildClass) {
        this.mediaChildClass = mediaChildClass;
    }

    public String getPositionType() {
        return positionType;
    }

    public void setPositionType(String positionType) {
        this.positionType = positionType;
    }

    public String getAppKey() {
        return appKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public String getBusiness() {
        return business;
    }

    public Byte getCooperationType() {
        return cooperationType;
    }

    public void setCooperationType(Byte cooperationType) {
        this.cooperationType = cooperationType;
    }

    public Byte getDockingMethod() {
        return dockingMethod;
    }

    public void setDockingMethod(Byte dockingMethod) {
        this.dockingMethod = dockingMethod;
    }

    public void setBusiness(String business) {
        this.business = business;
    }

    public Integer getConfig() {
        return config;
    }

    public void setConfig(Integer config) {
        this.config = config;
    }

    public Byte getNewWanliu() {
        return newWanliu;
    }

    public void setNewWanliu(Byte newWanliu) {
        this.newWanliu = newWanliu;
    }

    public String getStayWindowdsRegion() {
        return stayWindowdsRegion;
    }

    public void setStayWindowdsRegion(String stayWindowdsRegion) {
        this.stayWindowdsRegion = stayWindowdsRegion;
    }

    public String getStayWindowdsTime() {
        return stayWindowdsTime;
    }

    public void setStayWindowdsTime(String stayWindowdsTime) {
        this.stayWindowdsTime = stayWindowdsTime;
    }

    public Byte getMore() {
        return more;
    }

    public void setMore(Byte more) {
        this.more = more;
    }

    public Byte getActivityStatement() {
        return activityStatement;
    }

    public void setActivityStatement(Byte activityStatement) {
        this.activityStatement = activityStatement;
    }

    public String getIntro() {
        return intro;
    }

    public void setIntro(String intro) {
        this.intro = intro;
    }

    public Byte getRewardTicket() {
        return rewardTicket;
    }

    public void setRewardTicket(Byte rewardTicket) {
        this.rewardTicket = rewardTicket;
    }

    public Integer getRewardTicketCount() {
        return rewardTicketCount;
    }

    public void setRewardTicketCount(Integer rewardTicketCount) {
        this.rewardTicketCount = rewardTicketCount;
    }

    public Integer getNeedFloatMaterial() {
        return needFloatMaterial;
    }

    public void setNeedFloatMaterial(Integer needFloatMaterial) {
        this.needFloatMaterial = needFloatMaterial;
    }

    public String getPositionSize() {
        return positionSize;
    }

    public String getActRule() {
        return actRule;
    }

    public void setActRule(String actRule) {
        this.actRule = actRule;
    }

    public String getActExplain() {
        return actExplain;
    }

    public void setActExplain(String actExplain) {
        this.actExplain = actExplain;
    }

    public void setPositionSize(String positionSize) {
        this.positionSize = positionSize;
    }

    public Integer getAccountType() {
        return accountType;
    }

    public void setAccountType(Integer accountType) {
        this.accountType = accountType;
    }

    public Boolean getDspFlag() {
        return dspFlag;
    }

    public void setDspFlag(Boolean dspFlag) {
        this.dspFlag = dspFlag;
    }

    public String getEntranceScene() {
        return entranceScene;
    }

    public void setEntranceScene(String entranceScene) {
        this.entranceScene = entranceScene;
    }

    public String getProviderAlias() {
        return providerAlias;
    }

    public void setProviderAlias(String providerAlias) {
        this.providerAlias = providerAlias;
    }

    public String getAppEntranceAlias() {
        return appEntranceAlias;
    }

    public void setAppEntranceAlias(String appEntranceAlias) {
        this.appEntranceAlias = appEntranceAlias;
    }

    public Boolean getCouponsPutinFlag() {
        return couponsPutinFlag;
    }

    public void setCouponsPutinFlag(Boolean couponsPutinFlag) {
        this.couponsPutinFlag = couponsPutinFlag;
    }

    public Long getCouponsIconSize() {
        return couponsIconSize;
    }

    public void setCouponsIconSize(Long couponsIconSize) {
        this.couponsIconSize = couponsIconSize;
    }

    public Long getCouponsCreativeSize() {
        return couponsCreativeSize;
    }

    public void setCouponsCreativeSize(Long couponsCreativeSize) {
        this.couponsCreativeSize = couponsCreativeSize;
    }

    public Byte getPositionScene() {
        return positionScene;
    }

    public void setPositionScene(Byte positionScene) {
        this.positionScene = positionScene;
    }

    public Boolean getWechatMiniAppPutFlag() {
        return wechatMiniAppPutFlag;
    }

    public void setWechatMiniAppPutFlag(Boolean wechatMiniAppPutFlag) {
        this.wechatMiniAppPutFlag = wechatMiniAppPutFlag;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }
}
