package com.bxm.adsmanager.model.vo;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;

import org.apache.commons.lang3.StringUtils;

import com.bxm.adsmanager.model.constant.CommonConstant;
import com.bxm.adsmanager.model.dao.adkeeper.AdAssetsTemplateContent;

import lombok.Data;

/**
 * 广告券AppId包.</br>
 * Created by zhengwangeng on 2021/12/20
 */
@Data
public class AdAppIdPackageListVO implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * ID
     */
    private Long id;

    /**
     * 名称
     */
    private String name;

    /**
     * AppID列表，多个以逗号分隔
     */
    private String appIds;

    /**
     * AppId数量
     */
    private Integer appIdQuantity;

    public Integer getAppIdQuantity() {
        if (StringUtils.isBlank(appIds)) {
            return 0;
        }
        return appIds.split(CommonConstant.BaseCharacter.COMMA).length;
    }
}