package com.bxm.adsmanager.model.vo;

import lombok.Data;

import java.io.Serializable;

/**
 * 激励视频素材
 */
@Data
public class AdAssetsInspireVideoVo implements Serializable {

    private static final long serialVersionUID = 6075175676439515968L;

    private Long id;

    /**
     * 广告券ID
     */
    private Long ticketId;

    /**
     * 视频
     */
    private String videoUrl;

    /**
     * 标题
     */
    private String title;

    /**
     * ICON
     */
    private String iconUrl;

    /**
     * 素材名称
     */
    private String assetsName;

    /**
     * 广告内容
     */
    private String content;

    /**
     * 按钮内容
     */
    private String buttonContent;

    /**
     * 视频方向(1.横版 2.竖版)
     */
    private Short videoDirection;

    /**
     * 视频尺寸长度
     */
    private Integer videoHeight;

    /**
     * 视频尺寸宽度
     */
    private Integer videoWidth;

    /**
     * 视频时长
     */
    private Double videoDuration;

    /**
     * 1待审核   2 审核通过  3 审核拒绝
     */
    private Short auditStatus;

    /**
     * 拒绝原因
     */
    private String refuseReason;

    /**
     * 状态。0- 停用、1- 启用 2删除
     */
    private Short status;

    /**
     * 封面
     */
    private String coverUrl;

    /**
     * 视频文件大小byte
     */
    private Long videoFileSize;

    private Integer openPv;//曝光Pv

    private Integer clickPv;//点击Pv

    private String clickRate;//点击率

    private Integer validClick; // 有效点击
}