package com.bxm.adsmanager.model.vo;

import java.io.Serializable;

import lombok.Data;

/**
 * 素材模板素材
 */
@Data
public class AdAssetsTemplateAssetsVO implements Serializable {

    private static final long serialVersionUID = 6075175676439515968L;

    /**
     * ID
     */
    private Long id;

    /**
     * 广告券ID
     */
    private Long ticketId;

    /**
     * 状态。0- 停用、1- 启用 2删除
     */
    private Short status;

    /**
     * 素材名称
     */
    private String assetsName;

    /**
     * 盘古素材库ID,多个用逗号分隔
     */
    private String panguCreativeIds;

    /**
     * 具体素材配置，JSON数组
     */
    private String config;

    /**
     * 1待审核   2 审核通过  3 审核拒绝
     */
    private Short auditStatus;

    /**
     * 拒绝原因
     */
    private String refuseReason;

    /**
     * 检查状态：1已检查，2未检查
     */
    private Short checkStatus;

    /**
     * ADX审核状态：1-无效，2-审核中，3-审核不通过，4-审核通过
     */
    private Short adxAuditStatus;

    /**
     * ADX创意ID
     */
    private String adxCreativeId;

    /**
     * ADX审核结果信息
     */
    private String adxAuditMessage;

    /**
     * 曝光Pv
     */
    private Integer openPv;

    /**
     * 点击Pv
     */
    private Integer clickPv;

    /**
     * 有效点击
     */
    private Integer validClick;

    /**
     * 点击率
     */
    private String clickRate;

    /**
     * 点击转化率
     */
    private String clickConversionRate;

    /**
     * 曝光转化率
     */
    private String openConversionRate;
}