package com.bxm.adsmanager.model.vo;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import com.bxm.adsmanager.model.dao.adkeeper.AdAssetsTemplateContent;

import lombok.Data;

/**
 * 素材模板-券定向广告位.</br>
 * Created by zhengwangeng on 2022/1/10
 */
@Data
public class AdAssetsTemplateTicketListVO implements Serializable {

	private static final long serialVersionUID = 8255898196234336477L;

    /**
     * Id
     */
    private Long id;

    /**
     * 名称
     */
    private String name;

    /**
     * 快手素材模板类型：横图、竖图等。可能为空，为空的话表示未知。
     */
    private Integer type;

    /**
     * SDK模板类型
     * @see com.bxm.adsmanager.model.enums.AssetsTemplateSdkTemplateTypeEnum
     */
    private Integer sdkTemplateType;

    /**
     * 示例图片
     */
    private String demoPicture;

    /**
     * 状态。0- 停用、1- 启用 2删除
     */
    private Short status;

    /**
     * 管理广告位数量
     */
    private Integer associationsNum;

    /**
     * 扩展信息
     */
    private String ext;

    /**
     * 是否系统创建
     */
    private Short systemCreate;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 修改人
     */
    private String modifyUser;

    /**
     * 修改时间
     */
    private Date modifyTime;

    /**
     * 数字展示为该券下素材列表中未删除的使用该模版的素材数量
     */
    private Long assetsNum = 0L;

}