package com.bxm.adsmanager.model.vo;

import cn.afterturn.easypoi.excel.annotation.Excel;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class AdAuditRecordVo implements Serializable{
    private Long id;

    /**
     * 券id
     */
    @Excel(name = "广告ID")
    private Long ticketId;


    /**
     * 素材id
     */
    @Excel(name = "广告名称")
    private String ticketName;

    /**
     * 广告券类型。
     * @see com.bxm.adsmanager.model.dao.adkeeper.AdTicket.AdTicketType
     */
    private Short ticketType;

    @Excel(name = "券类型")
    private String ticketTypeStr;

    /**
     * 分类标签
     */
    @Excel(name = "分类标签")
    private String tagName;

    /**
     * 素材id
     */
    @Excel(name = "素材ID")
    private Long assetsId;

    /**
     * 素材名称
     */
    @Excel(name = "素材名称")
    private String assetsName;

    /**
     * 提交时间
     */
    private String submitTime;

    /**
     * 审核时间
     */
    private String auditTime;

    /**
     * 券审核状态（1通过   2 拒绝 ）
     */
    private Short ticketAuditStatus;

    /**
     * 素材审核状态（1通过   2 拒绝 ）
     */
    private Short assetsAuditStatus;

    /**
     * 审核类型（1.券 2.素材）
     */
    private Short auditType;

    /**
     * 提交时间
     */
    @Excel(name = "提交时间")
    private String submitTimeStr;

    /**
     * 审核时间
     */
    @Excel(name = "审核时间")
    private String auditTimeStr;

    /**
     * 券审核状态（1通过   2 拒绝 ）
     */
    @Excel(name = "券审核状态")
    private String ticketAuditStatusStr;

    /**
     * 素材审核状态（1通过   2 拒绝 ）
     */
    @Excel(name = "素材审核状态")
    private String assetsAuditStatusStr;

    /**
     * 审核人
     */
    @Excel(name = "审核人")
    private String auditUser;

}
