package com.bxm.adsmanager.model.vo;
/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the
 * confidential and proprietary information of bianxianmao.com ("Confidential
 * Information"). You shall not disclose such Confidential Information and shall
 * use it only in accordance with the terms of the license agreement you entered
 * into with bianxianmao.com.
 */


import java.util.Date;

import cn.afterturn.easypoi.excel.annotation.Excel;
import com.bxm.adsmanager.model.constant.CommonConstant;

/**
 * <h3>广告券的前端参数模版类</h3>
 * @author hcmony
 * @since V1.0.0, 2017/12/13 09:55
 */
public class AdTicketAllVo  {

    @Excel(name = "广告ID")
	private Long id;//id


    @Excel(name = "广告名称")
	private String name;//name

    /**
     * 一级标签名称
     */
    @Excel(name = "广告类别")
    private String tagName;

	/**
	 * 所属行业code
	 */
	private String domainCode;

	/**
	 * 所属行业名称
	 */
	private String domainName;

	private Long advertiser;//广告主id

    @Excel(name = "所属广告主")
	private String advertiserName;//广告主名称

	private Short type;//广告券类型。


	private Short status;//状态。0- 暂停、1- 正常、-1 已删除

    @Excel(name = "状态")
	private String pauseReason;//暂停原因。1- 超出预算、2- 余额不足

    @Excel(name = "日预算")
	private Double budgetDaily;//日限额（预算），CPC单位是元，CPA单位是张。0 表示无限额。如果是金额，单位：厘

    @Excel(name = "出价")
	private Double price;//单价

    @Excel(name = "结算方式", replace = { "CPC_1", "CPA_2" })
	private Short settleType;//结算方式：1- CPC、2- CPA、4- CPM

    @Excel(name = "账户余额")
	private Double advertiserBalance;

    /**
     * 曝光量（发券量）
     */
    @Excel(name = "发券量")
	private Integer openPv = 0;

    /**
     * 点击量
     */
    @Excel(name = "点击量")
	private Integer clickPv = 0;

    /**
     * 点击率
     */
    @Excel(name = "点击率")
	private Double clickRate = 0.0;

	/**
	 * 入口#曝光
	 */
	@Excel(name = "入口#曝光")
	private Integer entranceOpenPv = 0;

	/**
	 * 入口#点击
	 */
	@Excel(name = "入口#点击")
	private Integer entranceClickPv = 0;

	/**
	 * 入口#点击率
	 */
	@Excel(name = "入口#点击率")
	private Double entranceClickRate = 0.0;

	private Date validStartDate;//有效期开始

    /**
     * 点击率
     */
    @Excel(name = "结束时间", exportFormat = "yyyy-MM-dd HH:mm:ss")
	private Date validEndDate;//有效期结束

    /**
     * 点击率
     */
    @Excel(name = "有效点击", replace = {"0_null"})
	private String validClick;//有效点击

    /**
     * 消耗（广告主）
     */
    @Excel(name = "消耗")
	private Double consume;

	private Integer isSupportOcpc;//是否支持OCPC。0- 不支持、1- 支持
	
	private String createUser;//创建人

	private Date createTime;//创建时间

	private String modifyUser;//修改人

	private Date modifyTime;//修改时间

	private String refuseReason; //审核拒绝原因

	private Short lastStatus;

	private String urlTestResult;//券链接测试结果

	//ADX直投券的相关数据
	/**
	 * ae
	 */
	private String ae;

	/**
	 * adxAe
	 */
	private String adxAe;

	/**
	 * 结算方式：1- CPC、2- CPA、4- CPM
	 */
	private Short adxSettleType;

	/**
	 * 单价。单位：元
	 */
	private Double adxPrice = 0.0;

	/**
	 * adx出价类型
	 * @see com.bxm.adsmanager.model.enums.AdxPriceTypeEnum
	 */
	private Short adxPriceType;

	/**
	 * adxId 用于素材审核时判断是哪个Adx，也用于不同adx对素材进行不同的逻辑处理
	 * @see //com.bxm.adsmanager.model.enums.AdxIdEnum
	 */
	private Short adxId;

	/**
	 * 风控：0关闭，1开启
	 */
	private Short riskControl;

	/**
	 * adx审核状态
	 */
	private Short adxAuditStatus;

	/**
	 * adx审核信息
	 */
	private String adxAuditMessage;

	/**
	 * adx素材填充率
	 */
	private Double adxAssetsFillRate = 0.0;

	/**
	 * adx 出价目标cpa,单位：厘
	 */
	private Double adxTargetCpa;

	/**
	 * 日限额（预算），0 表示无限额。单位：元
	 */
	private Double adxBudgetDaily = 0.0;

	/**
	 * ADX消耗
	 */
	private Double adxConsume = 0.0;
	//ADX成本，这两个是一样的
	private Double adxCost = 0.0;

	/**
	 * ADX成本CPC：ADX成本/点击
 	 */
	private Double adxCpcCost = 0.0;
	/**
	 * ADX成本CPM:ADX成本/曝光*1000
	 */
	private Double adxCpmCost = 0.0;

	//ADX直投券广告位定向只有一个广告位，需要在列表展示名称和id信息
	/**
	 * 广告位名称
	 */
	private String positionName;

	/**
	 * 广告位 positionId
	 */
	private String positionId;

	/**
	 * 广告位别名
	 */
	private String positionIdCodeName;

	/**
	 *
	 * @return
	 */
	private Double crrentClickPrice = 0.0;

    // ADX直投 请求次数，出价次数、出价率、曝光数/出价次数
    /**
     * ADX直投 请求次数
     */
    private Integer requestNum;

    /**
     * ADX直投 出价次数
     */
    private Integer offerPriceNum;

    /**
     * ADX直投 出价率
     */
    private String offerPriceRate;

    /**
     * ADX直投 曝光数/出价次数
     */
    private String openPvOfferPriceRate;

    /**
     * 广告位场景定向(逗号分开)：1.互动广告 2.自渲染 4.开屏 5.信息流大图
     */
    private String positionSceneConfig;

    /**
     * ocpc阶段 1.一阶段 2.二阶段
     */
    private Integer ocpcStage;

    /**
     * 是否有落地页ab计划
     */
    private Boolean existLandPlan;

    /**
     * 素材选择类型 0.算法优选 1.手动配置
     */
    private Short assetsSelectType;

    /**
     * 近一周oCPC二阶段平均CPA
     *
     * @return
     */
    private Double secondStageWeekAvgCpa;

    /**
     * 目标cpa
     */
    private Double cpaExpectPrice;

    /**
     * 销售
     */
    private String sale;

    private Integer qualifyWarningFlag;

	private String exploreStatus;


    public Integer getQualifyWarningFlag() {
        return qualifyWarningFlag;
    }

    public void setQualifyWarningFlag(Integer qualifyWarningFlag) {
        this.qualifyWarningFlag = qualifyWarningFlag;
    }

    public Double getAdxCost() {
		return adxCost;
	}

	public void setAdxCost(Double adxCost) {
		this.adxCost = adxCost;
	}

	public Double getAdxCpcCost() {
		return adxCpcCost;
	}

	public void setAdxCpcCost(Double adxCpcCost) {
		this.adxCpcCost = adxCpcCost;
	}

	public Double getAdxCpmCost() {
		return adxCpmCost;
	}

	public void setAdxCpmCost(Double adxCpmCost) {
		this.adxCpmCost = adxCpmCost;
	}

	public Short getAdxPriceType() {
		return adxPriceType;
	}

	public void setAdxPriceType(Short adxPriceType) {
		this.adxPriceType = adxPriceType;
	}

	public Short getAdxId() {
		return adxId;
	}

	public void setAdxId(Short adxId) {
		this.adxId = adxId;
	}

	public Short getRiskControl() {
		return riskControl;
	}

	public void setRiskControl(Short riskControl) {
		this.riskControl = riskControl;
	}

	public Short getAdxAuditStatus() {
		return adxAuditStatus;
	}

	public void setAdxAuditStatus(Short adxAuditStatus) {
		this.adxAuditStatus = adxAuditStatus;
	}

	public String getAdxAuditMessage() {
		return adxAuditMessage;
	}

	public void setAdxAuditMessage(String adxAuditMessage) {
		this.adxAuditMessage = adxAuditMessage;
	}

	public Double getAdxAssetsFillRate() {
		return adxAssetsFillRate;
	}

	public void setAdxAssetsFillRate(Double adxAssetsFillRate) {
		this.adxAssetsFillRate = adxAssetsFillRate;
	}

	public Double getAdxTargetCpa() {
		return adxTargetCpa;
	}

	public void setAdxTargetCpa(Double adxTargetCpa) {
		this.adxTargetCpa = adxTargetCpa;
	}

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

    public String getValidClick() {
        return validClick;
    }

    public void setValidClick(String validClick) {
        this.validClick = validClick;
    }

    public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public Long getAdvertiser() {
		return advertiser;
	}

	public void setAdvertiser(Long advertiser) {
		this.advertiser = advertiser;
	}

	public String getAdvertiserName() {
		return advertiserName;
	}

	public void setAdvertiserName(String advertiserName) {
		this.advertiserName = advertiserName;
	}

	public Short getType() {
		return type;
	}

	public void setType(Short type) {
		this.type = type;
	}

	public Short getStatus() {
		return status;
	}

	public void setStatus(Short status) {
		this.status = status;
	}

	public String getPauseReason() {
		return pauseReason;
	}

	public void setPauseReason(String pauseReason) {
		this.pauseReason = pauseReason;
	}

    public Double getBudgetDaily() {
		return budgetDaily;
	}

	public void setBudgetDaily(Double budgetDaily) {
		this.budgetDaily = budgetDaily;
	}

	public Double getPrice() {
		return price;
	}

	public void setPrice(Double price) {
		this.price = price;
	}

	public Short getSettleType() {
		return settleType;
	}

	public void setSettleType(Short settleType) {
		this.settleType = settleType;
	}

	public Integer getOpenPv() {
		return openPv;
	}

	public void setOpenPv(Integer openPv) {
		this.openPv = openPv;
	}

	public Integer getClickPv() {
		return clickPv;
	}

	public void setClickPv(Integer clickPv) {
		this.clickPv = clickPv;
	}

	public Double getClickRate() {
		return clickRate;
	}

	public void setClickRate(Double clickRate) {
		this.clickRate = clickRate;
	}

	public Integer getEntranceOpenPv() {
		return entranceOpenPv;
	}

	public void setEntranceOpenPv(Integer entranceOpenPv) {
		this.entranceOpenPv = entranceOpenPv;
	}

	public Integer getEntranceClickPv() {
		return entranceClickPv;
	}

	public void setEntranceClickPv(Integer entranceClickPv) {
		this.entranceClickPv = entranceClickPv;
	}

	public Double getEntranceClickRate() {
		return entranceClickRate;
	}

	public void setEntranceClickRate(Double entranceClickRate) {
		this.entranceClickRate = entranceClickRate;
	}

	public Date getValidStartDate() {
		return validStartDate;
	}

	public void setValidStartDate(Date validStartDate) {
		this.validStartDate = validStartDate;
	}

	public Date getValidEndDate() {
		return validEndDate;
	}

	public void setValidEndDate(Date validEndDate) {
		this.validEndDate = validEndDate;
	}

	public Double getConsume() {
		return consume;
	}

	public void setConsume(Double consume) {
		this.consume = consume;
	}

	public Integer getIsSupportOcpc() {
        return isSupportOcpc;
    }

    public void setIsSupportOcpc(Integer isSupportOcpc) {
        this.isSupportOcpc = isSupportOcpc;
    }

	public Double getAdvertiserBalance() {
		return advertiserBalance;
	}

	public void setAdvertiserBalance(Double advertiserBalance) {
		this.advertiserBalance = advertiserBalance;
	}

    public String getCreateUser() {
        return createUser;
    }

	public String getExploreStatus() {
		return exploreStatus;
	}

	public void setExploreStatus(String exploreStatus) {
		this.exploreStatus = exploreStatus;
	}

	public void setCreateUser(String createUser) {
        this.createUser = createUser;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getModifyUser() {
        return modifyUser;
    }

    public void setModifyUser(String modifyUser) {
        this.modifyUser = modifyUser;
    }

    public Date getModifyTime() {
        return modifyTime;
    }

    public void setModifyTime(Date modifyTime) {
        this.modifyTime = modifyTime;
    }

	public String getRefuseReason() {
		return refuseReason;
	}

	public void setRefuseReason(String refuseReason) {
		this.refuseReason = refuseReason;
	}

	public Short getLastStatus() {
		return lastStatus;
	}

	public void setLastStatus(Short lastStatus) {
		this.lastStatus = lastStatus;
	}

    public String getTagName() {
        return tagName;
    }

    public void setTagName(String tagName) {
        this.tagName = tagName;
    }

	public String getUrlTestResult() {
		return urlTestResult;
	}

	public void setUrlTestResult(String urlTestResult) {
		this.urlTestResult = urlTestResult;
	}

	public String getDomainCode() {
		return domainCode;
	}

	public void setDomainCode(String domainCode) {
		this.domainCode = domainCode;
	}

	public String getDomainName() {
		return domainName;
	}

	public void setDomainName(String domainName) {
		this.domainName = domainName;
	}

    public String getAe() {
        return ae;
    }

    public void setAe(String ae) {
        this.ae = ae;
    }

    public String getAdxAe() {
		return adxAe;
	}

	public void setAdxAe(String adxAe) {
		this.adxAe = adxAe;
	}

	public Short getAdxSettleType() {
		return adxSettleType;
	}

	public void setAdxSettleType(Short adxSettleType) {
		this.adxSettleType = adxSettleType;
	}

	public Double getAdxPrice() {
		return adxPrice;
	}

	public void setAdxPrice(Double adxPrice) {
		this.adxPrice = adxPrice;
	}

	public Double getAdxBudgetDaily() {
		return adxBudgetDaily;
	}

	public void setAdxBudgetDaily(Double adxBudgetDaily) {
		this.adxBudgetDaily = adxBudgetDaily;
	}

	public Double getAdxConsume() {
		return adxConsume;
	}

	public void setAdxConsume(Double adxConsume) {
		this.adxConsume = adxConsume;
	}

	public String getPositionName() {
		return positionName;
	}

	public void setPositionName(String positionName) {
		this.positionName = positionName;
	}

	public String getPositionId() {
		return positionId;
	}

	public void setPositionId(String positionId) {
		this.positionId = positionId;
	}

	public String getPositionIdCodeName() {
		return positionIdCodeName;
	}

	public void setPositionIdCodeName(String positionIdCodeName) {
		this.positionIdCodeName = positionIdCodeName;
	}

	public Double getCrrentClickPrice() {
		return crrentClickPrice;
	}

	public void setCrrentClickPrice(Double crrentClickPrice) {
		this.crrentClickPrice = crrentClickPrice;
	}

    public Integer getRequestNum() {
        return requestNum;
    }

    public void setRequestNum(Integer requestNum) {
        this.requestNum = requestNum;
    }

    public Integer getOfferPriceNum() {
        return offerPriceNum;
    }

    public void setOfferPriceNum(Integer offerPriceNum) {
        this.offerPriceNum = offerPriceNum;
    }

    public String getOfferPriceRate() {
        return offerPriceRate;
    }

    public void setOfferPriceRate(String offerPriceRate) {
        this.offerPriceRate = offerPriceRate;
    }

    public String getOpenPvOfferPriceRate() {
        return openPvOfferPriceRate;
    }

    public void setOpenPvOfferPriceRate(String openPvOfferPriceRate) {
        this.openPvOfferPriceRate = openPvOfferPriceRate;
    }

    public String getPositionSceneConfig() {
        return positionSceneConfig;
    }

    public void setPositionSceneConfig(String positionSceneConfig) {
        this.positionSceneConfig = positionSceneConfig;
    }

    public Integer getOcpcStage() {
        return ocpcStage;
    }

    public void setOcpcStage(Integer ocpcStage) {
        this.ocpcStage = ocpcStage;
    }

    public Boolean getExistLandPlan() {
        return existLandPlan;
    }

    public void setExistLandPlan(Boolean existLandPlan) {
        this.existLandPlan = existLandPlan;
    }

    public Short getAssetsSelectType() {
        return assetsSelectType;
    }

    public void setAssetsSelectType(Short assetsSelectType) {
        this.assetsSelectType = assetsSelectType;
    }

    public Double getSecondStageWeekAvgCpa() {
        return secondStageWeekAvgCpa;
    }

    public void setSecondStageWeekAvgCpa(Double secondStageWeekAvgCpa) {
        this.secondStageWeekAvgCpa = secondStageWeekAvgCpa;
    }

    public Double getCpaExpectPrice() {
        return cpaExpectPrice;
    }

    public void setCpaExpectPrice(Double cpaExpectPrice) {
        this.cpaExpectPrice = cpaExpectPrice;
    }

    public String getSale() {
        return sale;
    }

    public void setSale(String sale) {
        this.sale = sale;
    }


    /**
     * 是否为ocpc 包括ocpr券
     * @return
     */
    public boolean isOcpc() {
        if (isSupportOcpc != null && isSupportOcpc == 1) {
            return true;
        }
        if (CommonConstant.SettleTypeEnum.isOcpr(settleType)) {
            return true;
        }
        return false;
    }

	public boolean isOnlyOcpc() {
		if (isSupportOcpc != null && isSupportOcpc == 1) {
			return true;
		}
		return false;
	}
}
