package com.bxm.adsmanager.model.vo;

import lombok.Data;

import java.util.List;

/**
 * @author tangx
 * @date 2020/6/22 15:26
 */
@Data
public class AdTicketAuditVo {

    /**
     * 广告Id
     */
    private Integer ticketId;

    /**
     * 广告名称
     */
    private String ticketName;

    /**
     * 广告主Id
     */
    private Integer advertiserId;

    /**
     * 广告主名称
     */
    private String advertiserName;

    /**
     * 广告主:素材审核白名单状态 （0.非白名单 1.白名单）
     */
    private Byte assetAuditWhiteStatus;

    /**
     * 落地页
     */
    private String url;

    /**
     * 素材名称
     */
    private String assetsStr;

    /**
     * 素材图url
     */
    private String assetsImg;

    /**
     * 广告标签
     */
    private String tag;

    /**
     * 行业类型
     */
    private String TicketType;

    /**
     * 广告主状态
     */
    private Byte advertiserStatus;

    /**
     * 广告主资质
     */
    private String advertiserQuality;

    /**
     * 状态
     */
    private Integer ticketStatus;

    /**
     * 备注
     */
    private String remark;

    /**
     * 历史截图
     */
    private String historyShot;

    private String lastStatus;

    /**
     * 广告分类
     */
    private String domainCode;

    /**
     * 标签code 逗号分隔
     */
    private String tagCodes;

    /**
     * 素材广告介绍
     */
    private String intro;

    /**
     * 按钮文案
     */
    private String buttonTxt;

    private String ae;


    /**
     * 券类型
     */
    private Short type;

    /**
     * 资质警告标识
     */
    private Integer qualifyWarningFlag;

    private List<AdAssetsVo> adAssetsVoList;

    private List<AdAssetsInspireVideoVo> inspireVideoVoList;

    private List<AdAssetsTemplateAssetsAuditVO> templateAssetsVoList;

    /**
     * 地区类型：0.国内 1.海外
     */
    private Integer areaType;

    /**
     * 是否特批广告主 0.否 1.是
     */
    private Byte specialApproval;

    /**
     *
     */
    private String assetsAuditInfo;

}
