package com.bxm.adsmanager.model.vo;

import com.bxm.commons.currency.Money;

/**
 * <p>广告券流量包出价配置明细</p>
 *
 * @author kerry.jiang
 * @date 2019-7-4 12:07
 */
public class AdTicketFlowPackageOfferRelationVo {

    private Long id;//ID

    private Long flowPackageOfferConfId;//流量包配置ID
    private Long flowPackageId;//流量包ID
    private String  packageName;//流量包名称
    private Integer count;//广告位数量
    private String consume;//今日消耗

    private Long price;//出价, 单位厘
    private Double priceYuan;//出价, 单位元

    private String quota;//限额,单位元,infinity:表示不限

    /**
     * cpa 出价, 单位厘
     */
    private Long cpaPrice;
    private Double cpaPriceYuan;

    /**
     * 深层目标cpa出价, 单位厘
     */
    private Long deepCpaPrice;
    private Double deepCpaPriceYuan;



    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getFlowPackageOfferConfId() {
        return flowPackageOfferConfId;
    }

    public void setFlowPackageOfferConfId(Long flowPackageOfferConfId) {
        this.flowPackageOfferConfId = flowPackageOfferConfId;
    }

    public Long getFlowPackageId() {
        return flowPackageId;
    }

    public void setFlowPackageId(Long flowPackageId) {
        this.flowPackageId = flowPackageId;
    }

    public String getPackageName() {
        return packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public Integer getCount() {
        return count;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    public String getConsume() {
        return consume;
    }

    public void setConsume(String consume) {
        this.consume = consume;
    }

    public Long getPrice() {
        return price;
    }

    public void setPrice(Long price) {
        this.price = price;
    }

    public Double getPriceYuan() {
        if(price!=null) {
            Money money = Money.ofLi(price);
            return money.getYuan();
        }
        return priceYuan;
    }

    public void setPriceYuan(Double priceYuan) {
        this.priceYuan = priceYuan;
    }

    public String getQuota() {
        return quota;
    }

    public void setQuota(String quota) {
        this.quota = quota;
    }

    public Long getCpaPrice() {
        return cpaPrice;
    }

    public void setCpaPrice(Long cpaPrice) {
        this.cpaPrice = cpaPrice;
    }

    public Double getCpaPriceYuan() {
        if(cpaPrice!=null) {
            Money money = Money.ofLi(cpaPrice);
            return money.getYuan();
        }
        return cpaPriceYuan;
    }

    public Long getDeepCpaPrice() {
        return deepCpaPrice;
    }

    public void setDeepCpaPrice(Long deepCpaPrice) {
        this.deepCpaPrice = deepCpaPrice;
    }

    public Double getDeepCpaPriceYuan() {
        if(deepCpaPrice!=null) {
            Money money = Money.ofLi(deepCpaPrice);
            return money.getYuan();
        }
        return deepCpaPriceYuan;
    }
}
