package com.bxm.adsmanager.model.vo;

import com.bxm.commons.currency.Money;

/**  
* @Title: AdTicketIncomeDetailVo 
* @Description:  礼券收益信息总表返回信息
* @author xavier  
* @date 2018年3月5日  
*/  
public class AdTicketIncomeDetailVo {

	private Integer id;
	
	/** 时间 */  
	private String datetime;
	/** 礼券ID */
	private Long ticketId;
	/** 礼券名称 */
	private String ticketName;
	/** 广告主ID */
	private Long advertiserId;
	/** 广告主名称 */
	private String advertiserName;
	/** 单价 */
	private Integer unitPrice;
	private Double unitPriceShow;
	/** 点击量 */
	private Integer clickPv;
	/** 结算类型 */
	private String settleType;
	/** 结算数值 */
	private Integer settleNum;
	/** 礼券收入 */
	private Integer ticketIncome;
	private Double ticketIncomeShow;
	/** 独立成本 */
	private Integer  fixCost; 
	private Double  fixCostShow; 
	/** 分成收入 */
	private Integer divideIncome;
	private Double divideIncomeShow;
	/** 实际收入 */
	private Integer actualIncome;
	private Double actualIncomeShow;
	/** AE */
	private String ae;
	/** 礼券销售 */
	private String sale;
	/** 状态 */
	private Integer status;
	/** 备注 */
	private String remark;
	/** 分成备注 */
	private String divideRemark;

	public Integer getId() {
		return id;
	}

	public void setId(Integer id) {
		this.id = id;
	}

	public Double getUnitPriceShow() {
		if (unitPrice != null) {
			Money money = Money.ofLi(unitPrice);
			unitPriceShow = money.getYuan();
		}
		return unitPriceShow;
	}
	public void setUnitPriceShow(Double unitPriceShow) {
		this.unitPriceShow = unitPriceShow;
	}
	public Double getTicketIncomeShow() {
		if (ticketIncome != null) {
			Money money = Money.ofLi(ticketIncome);
			ticketIncomeShow = money.getYuan();
			return ticketIncomeShow;
		}
		return 0.0;
	}
	public void setTicketIncomeShow(Double ticketIncomeShow) {
		this.ticketIncomeShow = ticketIncomeShow;
	}
	public Double getFixCostShow() {
		if (fixCost != null) {
			Money money = Money.ofLi(fixCost);
			fixCostShow = money.getYuan();
		}
		return fixCostShow;
	}
	public void setFixCostShow(Double fixCostShow) {
		this.fixCostShow = fixCostShow;
	}
	public Double getDivideIncomeShow() {
		if (divideIncome != null) {
			Money money = Money.ofLi(divideIncome);
			divideIncomeShow = money.getYuan();
		}
		return divideIncomeShow;
	}
	public void setDivideIncomeShow(Double divideIncomeShow) {
		this.divideIncomeShow = divideIncomeShow;
	}
	public Double getActualIncomeShow() {
		if (actualIncome != null) {
			Money money = Money.ofLi(actualIncome);
			actualIncomeShow = money.getYuan();
			return actualIncomeShow;
		}
		return 0.0;
	}
	public void setActualIncomeShow(Double actualIncomeShow) {
		this.actualIncomeShow = actualIncomeShow;
	}
	public String getAe() {
		return ae;
	}
	public void setAe(String ae) {
		this.ae = ae;
	}
	public String getSale() {
		return sale;
	}
	public void setSale(String sale) {
		this.sale = sale;
	}
	public Integer getStatus() {
		return status;
	}
	public void setStatus(Integer status) {
		this.status = status;
	}
	public String getDatetime() {
		return datetime;
	}
	public void setDatetime(String datetime) {
		this.datetime = datetime;
	}
	public Long getTicketId() {
		return ticketId;
	}
	public void setTicketId(Long ticketId) {
		this.ticketId = ticketId;
	}
	public String getTicketName() {
		return ticketName;
	}
	public void setTicketName(String ticketName) {
		this.ticketName = ticketName;
	}
	public Long getAdvertiserId() {
		return advertiserId;
	}
	public void setAdvertiserId(Long advertiserId) {
		this.advertiserId = advertiserId;
	}
	public String getAdvertiserName() {
		return advertiserName;
	}
	public void setAdvertiserName(String advertiserName) {
		this.advertiserName = advertiserName;
	}
	public Integer getUnitPrice() {
		return unitPrice;
	}
	public void setUnitPrice(Integer unitPrice) {
		this.unitPrice = unitPrice;
	}
	public Integer getClickPv() {
		return clickPv;
	}
	public void setClickPv(Integer clickPv) {
		this.clickPv = clickPv;
	}
	public String getSettleType() {
		return settleType;
	}
	public void setSettleType(String settleType) {
		this.settleType = settleType;
	}
	public Integer getSettleNum() {
		return settleNum;
	}
	public void setSettleNum(Integer settleNum) {
		this.settleNum = settleNum;
	}
	public String getRemark() {
		return remark;
	}
	public void setRemark(String remark) {
		this.remark = remark;
	}
	public String getDivideRemark() {
		return divideRemark;
	}
	public void setDivideRemark(String divideRemark) {
		this.divideRemark = divideRemark;
	}
	public Integer getTicketIncome() {
		if(null == ticketIncome){
			return 0;
		}
		return ticketIncome;
	}
	public void setTicketIncome(Integer ticketIncome) {
		this.ticketIncome = ticketIncome;
	}
	public Integer getFixCost() {
		return fixCost;
	}
	public void setFixCost(Integer fixCost) {
		this.fixCost = fixCost;
	}
	public Integer getDivideIncome() {
		return divideIncome;
	}
	public void setDivideIncome(Integer divideIncome) {
		this.divideIncome = divideIncome;
	}
	public Integer getActualIncome() {
		return actualIncome;
	}
	public void setActualIncome(Integer actualIncome) {
		this.actualIncome = actualIncome;
	}
	
}
