package com.bxm.adsmanager.model.vo;

import java.io.Serializable;
import java.util.List;

import com.bxm.adsmanager.model.dao.adkeeper.AdTicketPositionTimesLimit;

import lombok.Data;

/**
 * <p>
 * 广告券-分时段对广告位限制配置
 * </p>
 *
 * @author zhengwangeng
 * @since 2021/3/9 17:41
 */
@Data
public class AdTicketPositionTimesLimitConfigVo implements Serializable {

    private static final long serialVersionUID = 2295350152450671383L;

    /**
     * ID
     */
    private Long id;

    /**
     * 配置名称
     */
    private String configName;

    /**
     *  开始时间,精确到小时，24小时格式 如 上午0:59 就是 0
     *  闭区间 >=
     * {@see LocalDateTime.now().getHour() }
     */
    private Long startHour;

    /**
     * 开始时间,精确到小时，24小时格式 如 下午23:53 就是 23
     * 开区间 <
     * {@see LocalDateTime.now().getHour() }
     */
    private Long endHour;

    /**
     * 对应广告位配置集合
     */
    private List<AdTicketPositionTimesLimitVo> ticketPositionTimesLimitList;

}