package com.bxm.adsmanager.model.vo;

import java.io.Serializable;
import java.util.List;

import com.bxm.adsprod.facade.ticket.TicketPositionTimesLimit;
import com.bxm.commons.currency.Money;

import lombok.Data;

/**
 * <p>
 * 广告券-分时段对广告位出价限额限制配置
 * </p>
 *
 * @author zhengwangeng
 * @since 2021/3/9 17:41
 */
@Data
public class  AdTicketPositionTimesLimitVo implements Serializable {

    private static final long serialVersionUID = -912820683566220672L;

    /**
     * ID
     */
    private Long id;

    /**
     * 广告位,如:  7fb4175c3a7e41e7808bf96eecc4ed98-1
     */
    private String position;

    /**
     * cpc 出价
     */
    private Long cpcPrice;

    /**
     * cpa 出价
     */
    private Long cpaPrice;

    /**
     * 深层目标cpa出价
     */
    private Long deepCpaPrice;

    /**
     * 限额
     */
    private Long limitPrice;

    /**
     * 一键复苏开关：0关闭，1开启
     */
    private Short oneClickRecovery;

    /**
     * 今日消耗
     */
    private String consume;

    /**
     * cpc 出价
     */
    private Double cpcPriceYuan;

    /**
     * cpa 出价
     */
    private Double cpaPriceYuan;

    /**
     * 深层目标cpa出价Yuan
     */
    private Double deepCpaPriceYuan;

    /**
     * 限额
     */
    private Double limitPriceYuan;

    public Double getCpcPriceYuan() {
        if(cpcPrice != null) {
            Money money = Money.ofLi(cpcPrice);
            return money.getYuan();
        }
        return cpcPriceYuan;
    }

    public void setCpcPriceYuan(Double cpcPriceYuan) {
        this.cpcPriceYuan = cpcPriceYuan;
    }

    public Double getCpaPriceYuan() {
        if(cpaPrice != null) {
            Money money = Money.ofLi(cpaPrice);
            return money.getYuan();
        }
        return cpaPriceYuan;
    }

    public Double getDeepCpaPriceYuan() {
        if(deepCpaPrice != null) {
            Money money = Money.ofLi(deepCpaPrice);
            return money.getYuan();
        }
        return deepCpaPriceYuan;
    }

    public void setCpaPriceYuan(Double cpaPriceYuan) {
        this.cpaPriceYuan = cpaPriceYuan;
    }

    public Double getLimitPriceYuan() {
        if(limitPrice != null) {
            Money money = Money.ofLi(limitPrice);
            return money.getYuan();
        }
        return limitPriceYuan;
    }

    public void setLimitPriceYuan(Double limitPriceYuan) {
        this.limitPriceYuan = limitPriceYuan;
    }
}