package com.bxm.adsmanager.model.vo;

import com.bxm.adsmanager.model.base.BaseDto;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicketOcpcConf;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicketPersonsGradeConf;
import com.bxm.commons.currency.Money;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;

/**
 * <h3>广告券的前端参数模版类</h3>
 * @author hcmony
 * @since V1.0.0, 2017/12/07 18:55
 */
public class AdTicketVo extends BaseDto {

    private static final long serialVersionUID = 3517845342918764304L;

    private String name;//name

	private Long advertiser;//广告主id   // 调广告主接口

	private String advertiserName;

	private Short settleType;//结算方式：1- CPC、2- CPA、4- CPM

	private String settleTypeText;

	private Double price;//单价

	private Short type;//广告券类型。

	private Double budgetDaily;//日限额（预算），CPC单位是元，CPA单位是张。0 表示无限额。如果是金额，单位：厘

	private Integer consumeModal; // 投放模式：0-加速、1-匀速

	private String domainCode;//所属行业 广告分类   // tbl_ad_domain 调接口 数据采集

	private Double standaloneCost;//独立成本。百分比

	private String url;//落地页

	@DateTimeFormat(pattern = "yyyy-MM-dd")
	private Date validStartDate;//有效期开始

	@DateTimeFormat(pattern = "yyyy-MM-dd")
	private Date validEndDate;//有效期结束

	@Deprecated
	private Short isSupportWechat;//是否支持微信。0- 不支持、1- 支持
	private String apps;

	private Integer userGradePassScore;//用户评分及格分数线

	private Short status;//状态。0- 暂停、1- 正常、-1 已删除

	private Integer pauseReason;//暂停原因。1- 超出预算、2- 余额不足

	//权重
	private Double weight;  //tbl_ad_ticket_weight_manual_conf 1对1

	//广告素材   调素材添加接口，返回广告券素材列表  传广告素材表id tbl_ad_assets 存入关联表中tbl_ad_ticket_assets_ref
	private String assetsids;

	//广告标签  tbl_ad_tag 调接口 数据采集
	private String tags; //1对多 tbl_ad_rules   1-1-100

	//区域定向  city=城市 缺城市表，然后写接口调城市列表 调 张凯接口  tbl_ad_rules
	private String citys; //1对多 tbl_ad_rules  110000,522501
     //区域定向  ipLibrary=指定ip库 
	private  String  ipLibrary;
	public String getIpLibrary() {
		return ipLibrary;
	}

	public void setIpLibrary(String ipLibrary) {
		this.ipLibrary = ipLibrary;
	}

	//操作平台  数组 json 格式
	private String oss; //1对多  tbl_ad_ticket_os_conf

	//人群定向   要调个推接口匹配数据 json 格式
	private AdTicketPersonsGradeConf ref;  //tbl_ad_ticket_persons_grade_conf 1对1

	private String personsGradeConf;

	//投放控制
	private ControlVo controlVo;
	private Long groupId;
	/**
	 * 是否开启广告组
	 */
	 private Boolean isGroup;
	
	 private Boolean booleanCitys;
	
	 private String createUser;//创建人
	 
	 private String modifyUser;//修改人

	private Date modifyTime;//修改时间
	 
	 private String log;

	 private String ae;

	//OCPC
	private OcpcConfVo ocpcConf;

	//流量控制
	private List<AdFlowPackageNewVo> adFlows;//原流量包列表
	/**
	 * 流量包出价配置ID
	 */
	private Long flowPackageOfferConfId;
	/**
	 * 流量包出价配置列表
	 */
	private List<AdTicketFlowPackageOfferConfVo> flowPackageArrayConfs;
	/**
	 * 广告位出价限额配置列表
	 */
	private List<AdTicketPositionTimesLimitConfigVo> positionTimesLimitConfig;


	// 广告票券码素材不能为空,至少添加一套展示位，浮标位素材
	private String                   assetscouponsids;
	private CouponsInfoVo  couponsInfoVo;               //票券码类的基本信息

	private String                   assetsadxids;// ADX素材
	private AdxConfVo  adxConfVo;               //ADX配置信息

	private String                   assetsinspirevideoids;// 激励视频素材
	private InspireVideoConfVo inspireVideoConfVo;// 激励视频配置信息

	private  Short aim;

    private TicketAppExtendVo ticketAppExtendVo; // 券app相关扩展配置

	private short isEffectMonitor;     //是否接入效果监控; 1-否 2-接入且精确  3-接入但不准

    /**
     * 广告位场景定向(逗号分开)：1.互动广告 2.自渲染 4.开屏 5.信息流大图
     */
    private String positionSceneConfig;

	/**
	 * 流量控制备用配置
	 */
	private String trafficControlBakConfig;

	/**
	 * 权益奖励ID
	 */
	private Long rightsId;

	/**
	 * 域名组ID
	 */
	private String kylinGroupId;

	/**
	 * 效果监控转化目标（OCPA必传）
	 */
	private Short targetConvType;

	/**
	 *  rtb对应的开发者
	 */
	private String rtbAppKey;
    /**
     * 追价预算余额
     */
    private Double chasePriceBalance;

    /**
     * 追价CPC出价
     */
    private Double chasePriceCpcPrice;

    /**
     * 追价CPC出价配置的广告主id，多个用逗号分开
     */
    private String chasePriceCpcPositionId;

    /**
     * 广告位追价配置
     */
    private String chasePriceConfig;

    /**
     * 广告&活动标签 用于直投集合页活动
     */
    private Integer ticketActivityMatchTag;

    /**
     * 是否去重有效点击 0.是 1.否
     */
    private Byte deduplicateValidClick;

	/**
	 * 算法优化目标（1单目标优化 2 双目标优化）
	 */
	private Short algoTarget;


    public String getChasePriceConfig() {
        return chasePriceConfig;
    }

    public void setChasePriceConfig(String chasePriceConfig) {
        this.chasePriceConfig = chasePriceConfig;
    }

    public Short getAlgoTarget() {
		return algoTarget;
	}

	public void setAlgoTarget(Short algoTarget) {
		this.algoTarget = algoTarget;
	}

	public String getChasePriceCpcPositionId() {
        return chasePriceCpcPositionId;
    }

    public void setChasePriceCpcPositionId(String chasePriceCpcPositionId) {
        this.chasePriceCpcPositionId = chasePriceCpcPositionId;
    }

    public Byte getDeduplicateValidClick() {
        return deduplicateValidClick;
    }

    public void setDeduplicateValidClick(Byte deduplicateValidClick) {
        this.deduplicateValidClick = deduplicateValidClick;
    }

    public Integer getTicketActivityMatchTag() {
        return ticketActivityMatchTag;
    }

    public void setTicketActivityMatchTag(Integer ticketActivityMatchTag) {
        this.ticketActivityMatchTag = ticketActivityMatchTag;
    }

    public Double getChasePriceBalance() {
        return chasePriceBalance;
    }

    public void setChasePriceBalance(Double chasePriceBalance) {
        this.chasePriceBalance = chasePriceBalance;
    }

    public Double getChasePriceCpcPrice() {
        return chasePriceCpcPrice;
    }

    public void setChasePriceCpcPrice(Double chasePriceCpcPrice) {
        this.chasePriceCpcPrice = chasePriceCpcPrice;
    }

	public Short getTargetConvType() {
		return targetConvType;
	}

	public void setTargetConvType(Short targetConvType) {
		this.targetConvType = targetConvType;
	}

	public String getRtbAppKey() {
		return rtbAppKey;
	}

	public void setRtbAppKey(String rtbAppKey) {
		this.rtbAppKey = rtbAppKey;
	}

	public String getKylinGroupId() {
		return kylinGroupId;
	}

	public void setKylinGroupId(String kylinGroupId) {
		this.kylinGroupId = kylinGroupId;
	}

	public Date getModifyTime() {
		return modifyTime;
	}

	public void setModifyTime(Date modifyTime) {
		this.modifyTime = modifyTime;
	}

	public Integer getConsumeModal() {
		return consumeModal;
	}

	public void setConsumeModal(Integer consumeModal) {
		this.consumeModal = consumeModal;
	}

	public Short getAim() {
		return aim;
	}

	public void setAim(Short aim) {
		this.aim = aim;
	}
	public String getLog() {
        return log;
    }

    public void setLog(String log) {
        this.log = log;
    }

    public String getCreateUser() {
        return createUser;
    }

    public void setCreateUser(String createUser) {
        this.createUser = createUser;
    }

    public String getModifyUser() {
        return modifyUser;
    }

    public void setModifyUser(String modifyUser) {
        this.modifyUser = modifyUser;
    }

    public Boolean getBooleanCitys() {
        return booleanCitys;
    }

    public void setBooleanCitys(Boolean booleanCitys) {
        this.booleanCitys = booleanCitys;
    }

    public Long getGroupId() {
		return groupId;
	}

	public void setGroupId(Long groupId) {
		this.groupId = groupId;
	}

	public Boolean getIsGroup() {
		return isGroup;
	}

	public void setIsGroup(Boolean isGroup) {
		this.isGroup = isGroup;
	}
	
	public List<AdFlowPackageNewVo> getAdFlows() {
		return adFlows;
	}

	public void setAdFlows(List<AdFlowPackageNewVo> adFlows) {
		this.adFlows = adFlows;
	}

	public Long getFlowPackageOfferConfId() {
		return flowPackageOfferConfId;
	}

	public void setFlowPackageOfferConfId(Long flowPackageOfferConfId) {
		this.flowPackageOfferConfId = flowPackageOfferConfId;
	}

	public List<AdTicketFlowPackageOfferConfVo> getFlowPackageArrayConfs() {
		return flowPackageArrayConfs;
	}

	public void setFlowPackageArrayConfs(List<AdTicketFlowPackageOfferConfVo> flowPackageArrayConfs) {
		this.flowPackageArrayConfs = flowPackageArrayConfs;
	}

	public List<AdTicketPositionTimesLimitConfigVo> getPositionTimesLimitConfig() {
		return positionTimesLimitConfig;
	}

	public void setPositionTimesLimitConfig(List<AdTicketPositionTimesLimitConfigVo> positionTimesLimitConfig) {
		this.positionTimesLimitConfig = positionTimesLimitConfig;
	}

	public String getPositionSceneConfig() {
        return positionSceneConfig;
    }

    public void setPositionSceneConfig(String positionSceneConfig) {
        this.positionSceneConfig = positionSceneConfig;
    }

	public String getTrafficControlBakConfig() {
		return trafficControlBakConfig;
	}

	public void setTrafficControlBakConfig(String trafficControlBakConfig) {
		this.trafficControlBakConfig = trafficControlBakConfig;
	}

	public Long getRightsId() {
		return rightsId;
	}

	public void setRightsId(Long rightsId) {
		this.rightsId = rightsId;
	}

	public static class OcpcConfVo {
		private Short isSupportOcpc;
		private Double cpaExpectPrice;
		//追价cpa
		private Double  chaseCpaPrice;
		private Integer closeThreshold;
        private Double cpaDeepExpectPrice;
		private Integer deepExpectActionType;
		private Integer expectActionType;

		public static OcpcConfVo of(AdTicketOcpcConf orig) {
			if (null == orig) {
				return null;
			}
			OcpcConfVo dest = new OcpcConfVo();
			dest.setCloseThreshold(orig.getCloseThreshold());
			dest.setIsSupportOcpc(orig.getIsSupportOcpc());
			Integer cpaExpectPrice = orig.getCpaExpectPrice();
            Integer cpaDeepExpectPrice = orig.getCpaDeepExpectPrice();
			Integer  chaseCpaPrice =orig.getChaseCpaPrice();
            if (null != cpaExpectPrice) {
				dest.setCpaExpectPrice(Money.ofLi(cpaExpectPrice).getYuan());
			}
            if (null != cpaDeepExpectPrice) {
                dest.setCpaDeepExpectPrice(Money.ofLi(cpaDeepExpectPrice).getYuan());
            }
			if (null != chaseCpaPrice) {
				dest.setChaseCpaPrice(Money.ofLi(chaseCpaPrice).getYuan());
			}
			dest.setDeepExpectActionType(orig.getDeepExpectActionType());
			dest.setExpectActionType(orig.getExpectActionType());
			return dest;
		}

		public Integer getDeepExpectActionType() {
			return deepExpectActionType;
		}

		public void setDeepExpectActionType(Integer deepExpectActionType) {
			this.deepExpectActionType = deepExpectActionType;
		}

		public Double getCpaDeepExpectPrice() {
            return cpaDeepExpectPrice;
        }

        public void setCpaDeepExpectPrice(Double cpaDeepExpectPrice) {
            this.cpaDeepExpectPrice = cpaDeepExpectPrice;
        }

        public Short getIsSupportOcpc() {
			return isSupportOcpc;
		}

		public void setIsSupportOcpc(Short isSupportOcpc) {
			this.isSupportOcpc = isSupportOcpc;
		}

		public Double getCpaExpectPrice() {
			return cpaExpectPrice;
		}

		public void setCpaExpectPrice(Double cpaExpectPrice) {
			this.cpaExpectPrice = cpaExpectPrice;
		}

		public Integer getCloseThreshold() {
			return closeThreshold;
		}

		public void setCloseThreshold(Integer closeThreshold) {
			this.closeThreshold = closeThreshold;
		}

		public Double getChaseCpaPrice() {
			return chaseCpaPrice;
		}

		public Integer getExpectActionType() {
			return expectActionType;
		}

		public void setExpectActionType(Integer expectActionType) {
			this.expectActionType = expectActionType;
		}

		public void setChaseCpaPrice(Double chaseCpaPrice) {
			this.chaseCpaPrice = chaseCpaPrice;
		}
	}

	public static class ControlVo{

		/**
		 * 投放时段预算 {start}-{end}-{limit} start=开始时间。单位：小时 end=结束时间。单位：小时 limit=限额。金额或张，
		 * 金额单位：前端传递为元，后端保存为厘
		 * 1对多 tbl_ad_rules
		 */
		private String times;

		/**
		 * 投放时段出价 {start}-{end}-{limit}-{price}
		 * 金额单位：前端传递为元，后端保存为厘
		 * 1对多 tbl_ad_rules
		 */
		private String timeBidding;

		//广告位定向   先调用查询所有的广告位接口，传参数type=类型。1- 白名单、2- 黑名单position=广告位ID
		private String banners; //1对多  tbl_ad_rules

		//未获取到用户imei 是否投放
		private String noimei;//tbl_ad_ticket_onoff

		//个推imei未匹配是否投放
		private String imeinomatching; //tbl_ad_ticket_onoff

		/**
		 * 人群定向-人群设置，个推人群标签
		 */
		private String personsGrade; //tbl_ad_ticket_getui_tag_ref

		/**
		 * 频次控制规则 可以不填
		 * @see com.bxm.adsmanager.model.enums.RuleTypeEnum.PINCI
		 * tbl_ad_rules 1对1
		 */
		private String frequencys;

		/**
		 * 流量控制，1为流量包配置，2为不限，3为广告位配置
		 * 这里的取名是历史原因，20210309之前值的范围是1和2，没有3。
		 */
		private String isPackage;
		
	    private Boolean booleanTimes;

		/**
		 * 人群包定向
		 * 1对多 tbl_ad_rules
		 */
		private String crowdPackage;

		/**
		 * adx券出券券包
		 * 1对多 tbl_ad_rules
		 */
		private String ticketPackage;

		/**
		 * ADX App ID 定向
		 */
		private String adxAppIdRule;

		/**
		 * ISP运营商
		 * 格式是：运营商1，运营商2
		 * 1对多 tbl_ad_rules
		 */
		private String isp;

		/**
		 * 网络类型
		 * 格式是：3g，4g
		 * 1对多 tbl_ad_rules
		 */
		private String networkType;
		/**
		 * 广告位质量
		 * 格式是：1优质，2终端
		 * 1对多 tbl_ad_rules
		 */
		private String adQuality;
		/**
		 * 活动定向
		 * 格式是：活动id，活动id
		 * 1对多 tbl_ad_rules
		 */
		private String activityOrientation;

        /**
         *  新老用户定向
         */
        private String newAndOldUsers;

        /**
         * 性别定向
         */
        private String getuiSex;

		/**
		 * 百度性别定向
		 */
		private String besGender;

		/**
		 * 百度年龄定向
		 */
		private String besAge;

		/**
		 * 手机品牌
		 */
		private String phoneBrand;

		/**
		 * ADX App 入口流量定向
		 * 1- 白名单、2- 黑名单  ticketId=活动券ID
		 */
		private String adxAPPEntranceRule;

		/**
		 * AppID包定向
		 */
		private String appIdPackage;

        /**
         * Adx 广告位id定向
         */
        private String adxTagIdRule;

        /**
         * 国家定向
         * 为空表示不限 1- 白名单，2- 黑名单
         */
        private String country;

        /**
         * 百度looklike定向。 为空则是不定向
         * 定向类型定义：1.通用 2.会籍卡 3.盲盒
         * 定向阈值定义：
         * 1. 50<=相似度<60
         * 2. 60<=相似度<70
         * 3. 70<=相似度<80
         * 4. 80<=相似度<90
         * 5. 90<=相似度<=100
         */
        private String baiduLookLikeRule;


        public String getBaiduLookLikeRule() {
            return baiduLookLikeRule;
        }

        public void setBaiduLookLikeRule(String baiduLookLikeRule) {
            this.baiduLookLikeRule = baiduLookLikeRule;
        }

        public String getAdxTagIdRule() {
            return adxTagIdRule;
        }

        public void setAdxTagIdRule(String adxTagIdRule) {
            this.adxTagIdRule = adxTagIdRule;
        }

        public String getAppIdPackage() {
			return appIdPackage;
		}

		public void setAppIdPackage(String appIdPackage) {
			this.appIdPackage = appIdPackage;
		}

		public String getAdxAPPEntranceRule() {
			return adxAPPEntranceRule;
		}

		public void setAdxAPPEntranceRule(String adxAPPEntranceRule) {
			this.adxAPPEntranceRule = adxAPPEntranceRule;
		}

		public String getBesGender() {
			return besGender;
		}

		public void setBesGender(String besGender) {
			this.besGender = besGender;
		}

		public String getBesAge() {
			return besAge;
		}

		public void setBesAge(String besAge) {
			this.besAge = besAge;
		}

		public String getPhoneBrand() {
			return phoneBrand;
		}

		public void setPhoneBrand(String phoneBrand) {
			this.phoneBrand = phoneBrand;
		}

		public String getGetuiSex() {
            return getuiSex;
        }

        public void setGetuiSex(String getuiSex) {
            this.getuiSex = getuiSex;
        }

        public String getNewAndOldUsers() {
            return newAndOldUsers;
        }

        public void setNewAndOldUsers(String newAndOldUsers) {
            this.newAndOldUsers = newAndOldUsers;
        }

        public String getNetworkType() {
			return networkType;
		}

		public void setNetworkType(String networkType) {
			this.networkType = networkType;
		}

		public String getAdQuality() {
			return adQuality;
		}

		public void setAdQuality(String adQuality) {
			this.adQuality = adQuality;
		}

		public String getActivityOrientation() {
			return activityOrientation;
		}

		public void setActivityOrientation(String activityOrientation) {
			this.activityOrientation = activityOrientation;
		}
	    
        public Boolean getBooleanTimes() {
            return booleanTimes;
        }

        public void setBooleanTimes(Boolean booleanTimes) {
            this.booleanTimes = booleanTimes;
        }

        public String getIsPackage() {
			return isPackage;
		}

		public void setIsPackage(String isPackage) {
			this.isPackage = isPackage;
		}

		public String getTimes() {
			return times;
		}

		public void setTimes(String times) {
			this.times = times;
		}

		public String getTimeBidding() {
			return timeBidding;
		}

		public void setTimeBidding(String timeBidding) {
			this.timeBidding = timeBidding;
		}

		public String getBanners() {
			return banners;
		}

		public void setBanners(String banners) {
			this.banners = banners;
		}

		public String getNoimei() {
			return noimei;
		}

		public void setNoimei(String noimei) {
			this.noimei = noimei;
		}

		public String getImeinomatching() {
			return imeinomatching;
		}

		public void setImeinomatching(String imeinomatching) {
			this.imeinomatching = imeinomatching;
		}

		public String getPersonsGrade() {
			return personsGrade;
		}

		public void setPersonsGrade(String personsGrade) {
			this.personsGrade = personsGrade;
		}

		public String getFrequencys() {
			return frequencys;
		}

		public void setFrequencys(String frequencys) {
			this.frequencys = frequencys;
		}

		public String getCrowdPackage() {
			return crowdPackage;
		}

		public void setCrowdPackage(String crowdPackage) {
			this.crowdPackage = crowdPackage;
		}

		public String getTicketPackage() {
			return ticketPackage;
		}

		public void setTicketPackage(String ticketPackage) {
			this.ticketPackage = ticketPackage;
		}

		public String getAdxAppIdRule() {
			return adxAppIdRule;
		}

		public void setAdxAppIdRule(String adxAppIdRule) {
			this.adxAppIdRule = adxAppIdRule;
		}

		public String getIsp() {
			return isp;
		}

		public void setIsp(String isp) {
			this.isp = isp;
		}

        public String getCountry() {
            return country;
        }

        public void setCountry(String country) {
            this.country = country;
        }
    }


	public AdTicketPersonsGradeConf getRef() {
		return ref;
	}

	public void setRef(AdTicketPersonsGradeConf ref) {
		this.ref = ref;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public Long getAdvertiser() {
		return advertiser;
	}

	public void setAdvertiser(Long advertiser) {
		this.advertiser = advertiser;
	}

	public Short getSettleType() {
		return settleType;
	}

	public void setSettleType(Short settleType) {
		this.settleType = settleType;
	}

	public Double getPrice() {
		return price;
	}

	public void setPrice(Double price) {
		this.price = price;
	}

	public Short getType() {
		return type;
	}

	public void setType(Short type) {
		this.type = type;
	}

	public Double getBudgetDaily() {
		return budgetDaily;
	}

	public void setBudgetDaily(Double budgetDaily) {
		this.budgetDaily = budgetDaily;
	}

	public String getDomainCode() {
		return domainCode;
	}

	public void setDomainCode(String domainCode) {
		this.domainCode = domainCode;
	}

	public Double getStandaloneCost() {
		return standaloneCost;
	}

	public void setStandaloneCost(Double standaloneCost) {
		this.standaloneCost = standaloneCost;
	}

	public String getUrl() {
		return url;
	}

	public void setUrl(String url) {
		this.url = url;
	}

	public Date getValidStartDate() {
		return validStartDate;
	}

	public void setValidStartDate(Date validStartDate) {
		this.validStartDate = validStartDate;
	}

	public Date getValidEndDate() {
		return validEndDate;
	}

	public void setValidEndDate(Date validEndDate) {
		this.validEndDate = validEndDate;
	}

	public Short getIsSupportWechat() {
		return isSupportWechat;
	}

	public void setIsSupportWechat(Short isSupportWechat) {
		this.isSupportWechat = isSupportWechat;
	}

	public Integer getUserGradePassScore() {
		return userGradePassScore;
	}

	public void setUserGradePassScore(Integer userGradePassScore) {
		this.userGradePassScore = userGradePassScore;
	}

	public Short getStatus() {
		return status;
	}

	public void setStatus(Short status) {
		this.status = status;
	}

	public Integer getPauseReason() {
		return pauseReason;
	}

	public void setPauseReason(Integer pauseReason) {
		this.pauseReason = pauseReason;
	}

	public String getAssetsids() {
		return assetsids;
	}

	public void setAssetsids(String assetsids) {
		this.assetsids = assetsids;
	}

	public ControlVo getControlVo() {
		return controlVo;
	}

	public void setControlVo(ControlVo controlVo) {
		this.controlVo = controlVo;
	}

	public String getTags() {
		return tags;
	}

	public void setTags(String tags) {
		this.tags = tags;
	}

	public String getCitys() {
		return citys;
	}

	public void setCitys(String citys) {
		this.citys = citys;
	}

	public String getOss() {
		return oss;
	}

	public void setOss(String oss) {
		this.oss = oss;
	}

	public Double getWeight() {
		return weight;
	}

	public void setWeight(Double weight) {
		this.weight = weight;
	}

	public String getPersonsGradeConf() {
		return personsGradeConf;
	}

	public void setPersonsGradeConf(String personsGradeConf) {
		this.personsGradeConf = personsGradeConf;
	}

	public String getAdvertiserName() {
		return advertiserName;
	}

	public void setAdvertiserName(String advertiserName) {
		this.advertiserName = advertiserName;
	}

	public OcpcConfVo getOcpcConf() {
		return ocpcConf;
	}

	public void setOcpcConf(OcpcConfVo ocpcConf) {
		this.ocpcConf = ocpcConf;
	}

	public short getIsEffectMonitor() {
		return isEffectMonitor;
	}

	public void setIsEffectMonitor(short isEffectMonitor) {
		this.isEffectMonitor = isEffectMonitor;
	}

	public String getSettleTypeText() {
		if(null != this.getSettleType()){
			if(1==this.getSettleType().intValue()){
				return "CPC";
			}else if(2 == this.getSettleType().intValue()){
				return "CPA";
			}
		}
		return settleTypeText;
	}

	public void setSettleTypeText(String settleTypeText) {
		this.settleTypeText = settleTypeText;
	}

	public String getAe() {
		return ae;
	}

	public void setAe(String ae) {
		this.ae = ae;
	}

	public String getApps() {
		return apps;
	}

	public void setApps(String apps) {
		this.apps = apps;
	}

	public String getAssetscouponsids() {
		return assetscouponsids;
	}

	public void setAssetscouponsids(String assetscouponsids) {
		this.assetscouponsids = assetscouponsids;
	}

	public CouponsInfoVo getCouponsInfoVo() {
		return couponsInfoVo;
	}

	public void setCouponsInfoVo(CouponsInfoVo couponsInfoVo) {
		this.couponsInfoVo = couponsInfoVo;
	}

	public static class CouponsInfoVo {

		private Short useType;

		private String code;

		private Date codeStartTime;

		private Date codeEndTime;

		private Integer codeLimitNum;

		private String content;

		private String intro;

		private String packageName;

		//码各种状态的数量
		private Integer codeUnusedNum;
		private Integer codeReceivedNum;
		private Integer codeUsedNum;

		public Short getUseType() {
			return useType;
		}

		public void setUseType(Short useType) {
			this.useType = useType;
		}

		public String getCode() {
			return code;
		}

		public void setCode(String code) {
			this.code = code;
		}

		public Date getCodeStartTime() {
			return codeStartTime;
		}

		public void setCodeStartTime(Date codeStartTime) {
			this.codeStartTime = codeStartTime;
		}

		public Date getCodeEndTime() {
			return codeEndTime;
		}

		public void setCodeEndTime(Date codeEndTime) {
			this.codeEndTime = codeEndTime;
		}

		public Integer getCodeLimitNum() {
			return codeLimitNum;
		}

		public void setCodeLimitNum(Integer codeLimitNum) {
			this.codeLimitNum = codeLimitNum;
		}

		public String getContent() {
			return content;
		}

		public void setContent(String content) {
			this.content = content;
		}

		public String getIntro() {
			return intro;
		}

		public void setIntro(String intro) {
			this.intro = intro;
		}

		public String getPackageName() {
			return packageName;
		}

		public void setPackageName(String packageName) {
			this.packageName = packageName;
		}

		public Integer getCodeUnusedNum() {
			return codeUnusedNum;
		}

		public void setCodeUnusedNum(Integer codeUnusedNum) {
			this.codeUnusedNum = codeUnusedNum;
		}

		public Integer getCodeReceivedNum() {
			return codeReceivedNum;
		}

		public void setCodeReceivedNum(Integer codeReceivedNum) {
			this.codeReceivedNum = codeReceivedNum;
		}

		public Integer getCodeUsedNum() {
			return codeUsedNum;
		}

		public void setCodeUsedNum(Integer codeUsedNum) {
			this.codeUsedNum = codeUsedNum;
		}
	}

	public static class AdxConfVo {
		/**
		 * 每日最多曝光次数
		 */
		private Integer showMaximum;

		/**
		 * 每日最多点击次数
		 */
		private Integer clickMaximum;

		/**
		 * 投放速度：1- 加速投放、2- 匀速投放
		 */
		private Short speed;

		/**
		 * 人群来源：0- 内部标签
		 */
		private Short crowdSource;

		/**
		 * 结算方式：1- CPC、2- CPA、4- CPM
		 */
		private Short adxSettleType;

		/**
		 * 单价。单位：厘
		 */
		private Double adxPrice;

		/**
		 * 日限额（预算），0 表示无限额。单位：厘
		 */
		private Double adxBudgetDaily;

		/**
		 * adx专员
		 */
		private String adxAe;

		/**
		 * 投放类型：1，App下载；2，H5；3，deeplink
		 */
		private Short adxPutinType;

		/**
		 * 下载类型：默认为安卓，1，安卓；2，IOS
		 */
		private Short adxDownloadType;

		/**
		 * 下载安装包的AppID/包名
		 */
		private String adxPackageName;

		/**
		 * deeplink地址
		 */
		private String deeplinkUrl;

        /**
         * 美团一级行业
         */
        private String primaryIndustryId;

        /**
         * 美团二级行业
         */
        private String secondaryIndustryId;

		public Integer getShowMaximum() {
			return showMaximum;
		}

		public void setShowMaximum(Integer showMaximum) {
			this.showMaximum = showMaximum;
		}

		public Integer getClickMaximum() {
			return clickMaximum;
		}

		public void setClickMaximum(Integer clickMaximum) {
			this.clickMaximum = clickMaximum;
		}

		public Short getSpeed() {
			return speed;
		}

		public void setSpeed(Short speed) {
			this.speed = speed;
		}

		public Short getCrowdSource() {
			return crowdSource;
		}

		public void setCrowdSource(Short crowdSource) {
			this.crowdSource = crowdSource;
		}

		public Short getAdxSettleType() {
			return adxSettleType;
		}

		public void setAdxSettleType(Short adxSettleType) {
			this.adxSettleType = adxSettleType;
		}

		public Double getAdxPrice() {
			return adxPrice;
		}

		public void setAdxPrice(Double adxPrice) {
			this.adxPrice = adxPrice;
		}

		public Double getAdxBudgetDaily() {
			return adxBudgetDaily;
		}

		public void setAdxBudgetDaily(Double adxBudgetDaily) {
			this.adxBudgetDaily = adxBudgetDaily;
		}

		public String getAdxAe() {
			return adxAe;
		}

		public void setAdxAe(String adxAe) {
			this.adxAe = adxAe;
		}

		public Short getAdxPutinType() {
			return adxPutinType;
		}

		public void setAdxPutinType(Short adxPutinType) {
			this.adxPutinType = adxPutinType;
		}

		public Short getAdxDownloadType() {
			return adxDownloadType;
		}

		public void setAdxDownloadType(Short adxDownloadType) {
			this.adxDownloadType = adxDownloadType;
		}

		public String getAdxPackageName() {
			return adxPackageName;
		}

		public void setAdxPackageName(String adxPackageName) {
			this.adxPackageName = adxPackageName;
		}

		public String getDeeplinkUrl() {
			return deeplinkUrl;
		}

		public void setDeeplinkUrl(String deeplinkUrl) {
			this.deeplinkUrl = deeplinkUrl;
		}

        public String getPrimaryIndustryId() {
            return primaryIndustryId;
        }

        public void setPrimaryIndustryId(String primaryIndustryId) {
            this.primaryIndustryId = primaryIndustryId;
        }

        public String getSecondaryIndustryId() {
            return secondaryIndustryId;
        }

        public void setSecondaryIndustryId(String secondaryIndustryId) {
            this.secondaryIndustryId = secondaryIndustryId;
        }
    }

	public String getAssetsadxids() {
		return assetsadxids;
	}

	public void setAssetsadxids(String assetsadxids) {
		this.assetsadxids = assetsadxids;
	}

	public AdxConfVo getAdxConfVo() {
		return adxConfVo;
	}

	public void setAdxConfVo(AdxConfVo adxConfVo) {
		this.adxConfVo = adxConfVo;
	}

	public static class InspireVideoConfVo {
		/**
		 * 落地页类型，1下载类，2表单类，3deeplink
		 */
		private Short pageType;

		/**
		 * 下载安装包的AppID/包名
		 */
		private String packageName;

		/**
		 * 跳转地址
		 */
		private String jumpUrl;

		/**
		 * 未安装下载地址
		 */
		private String unInstallDownloadUrl;

		/**
		 * 三方监测渠道，1关闭，2热云，3talking data，4秒针
		 */
		private Short thirdPartyChannel;

		/**
		 * 曝光监测URL
		 */
		private String viewUrl;

		/**
		 * 点击监测URL
		 */
		private String clickUrl;

		/**
		 * 视频开始播放地址监测URL
		 */
		private String videoPlayStartUrl;

		/**
		 * 视频播放完成地址监测URL
		 */
		private String videoPlayEndUrl;

		public Short getPageType() {
			return pageType;
		}

		public void setPageType(Short pageType) {
			this.pageType = pageType;
		}

		public String getPackageName() {
			return packageName;
		}

		public void setPackageName(String packageName) {
			this.packageName = packageName;
		}

		public String getJumpUrl() {
			return jumpUrl;
		}

		public void setJumpUrl(String jumpUrl) {
			this.jumpUrl = jumpUrl;
		}

		public String getUnInstallDownloadUrl() {
			return unInstallDownloadUrl;
		}

		public void setUnInstallDownloadUrl(String unInstallDownloadUrl) {
			this.unInstallDownloadUrl = unInstallDownloadUrl;
		}

		public Short getThirdPartyChannel() {
			return thirdPartyChannel;
		}

		public void setThirdPartyChannel(Short thirdPartyChannel) {
			this.thirdPartyChannel = thirdPartyChannel;
		}

		public String getViewUrl() {
			return viewUrl;
		}

		public void setViewUrl(String viewUrl) {
			this.viewUrl = viewUrl;
		}

		public String getClickUrl() {
			return clickUrl;
		}

		public void setClickUrl(String clickUrl) {
			this.clickUrl = clickUrl;
		}

		public String getVideoPlayStartUrl() {
			return videoPlayStartUrl;
		}

		public void setVideoPlayStartUrl(String videoPlayStartUrl) {
			this.videoPlayStartUrl = videoPlayStartUrl;
		}

		public String getVideoPlayEndUrl() {
			return videoPlayEndUrl;
		}

		public void setVideoPlayEndUrl(String videoPlayEndUrl) {
			this.videoPlayEndUrl = videoPlayEndUrl;
		}
	}

	public InspireVideoConfVo getInspireVideoConfVo() {
		return inspireVideoConfVo;
	}

	public void setInspireVideoConfVo(InspireVideoConfVo inspireVideoConfVo) {
		this.inspireVideoConfVo = inspireVideoConfVo;
	}

	public String getAssetsinspirevideoids() {
		return assetsinspirevideoids;
	}

	public void setAssetsinspirevideoids(String assetsinspirevideoids) {
		this.assetsinspirevideoids = assetsinspirevideoids;
	}



    /**
     * ticket app扩展内容
     */
    public static class TicketAppExtendVo {
        /**
         * 落地页类型，1下载类，2表单类
         */
        private Short pageType;

        /**
         * 下载安装包的AppID/包名
         */
        private String packageName;

        /**
         * deeplink跳转地址
         */
        private String jumpUrl;

        /**
         * 曝光监测URL
         */
        private String viewUrl;

        /**
         * 点击监测URL
         */
        private String clickUrl;

        /**
         * 视频开始播放地址监测URL
         */
        private String videoPlayStartUrl;

        /**
         * 视频播放完成地址监测URL
         */
        private String videoPlayEndUrl;

        /**
         * deeplink吊起开始监测URL
         */
        private String deeplinkStartUrl;

        /**
         * deeplink吊起成功监测URL
         */
        private String deeplinkSuccessUrl;

        /**
         * deeplink吊起失败监测URL
         */
        private String deeplinkFailUrl;

        /**
         * app包名定向
         */
        private String appPackageRule;

        /**
         * 未获取到App列表时投放配率
         */
        private Integer appPackageRate;

        /**
         *  设备号定向 1.不限  2.仅设备号的流量
         */
        private String deviceOrientation;

		/**
		 * 媒体app包名定向
		 */
		private String mediaAppPackageRule;

		/**
		 * 无包名投放配率 0到100
		 */
		private Integer mediaAppPackageRate;

		/**
		 * Adx无App ID 投放配率： 0到100
		 */
		private Integer adxAppIdRate;

		/**
		 * 百度标签定向，多个用逗号分隔
		 */
		private String bdTagsOrientation;

		/**
		 * 百度BES广告标签
		 */
		private String bdTags;

		/**
		 * ADX CPM成本
		 */
		private Double adxPrice;

		/**
		 * adx出价类型
		 * @see com.bxm.adsmanager.model.enums.AdxPriceTypeEnum
		 */
		private Short adxPriceType;

		/**
		 * adx 出价目标cpa,单位：厘
		 */
		private Double adxTargetCpa;

		/**
		 * ADX成本日预算
		 */
		private Double adxBudgetDaily;

		/**
		 * 落地页最后一跳地址
		 */
		private String landingPageEndJumpUrl;

		/**
		 * RTA定向
		 */
		private Integer rta;

		/**
		 * RTA参数
		 */
		private String rtaParam;

		/**
		 * 下载落地页ID
		 */
		private Long downloadLandingPageId;

        /**
         * 人群包定向,多个逗号分隔
         */
        private String crowdPackageOrientation;

		/**
		 * adxId 用于素材审核时判断是哪个Adx，也用于不同adx对素材进行不同的逻辑处理
		 * @see //com.bxm.adsmanager.model.enums.AdxIdEnum
		 */
		private Short adxId;

		/**
		 * 风控：0关闭，1开启
		 */
		private Short riskControl;

		/**
		 * 首唤优化：0关闭，1开启
		 */
		private Short firstCallOptimization;

		/**
		 * 活动参与率，0-100之间的整数
		 */
		private Short participationRate;

		/**
		 * 操作系统版本定向（最低值）
		 */
		private String osVersionOrientation;

		/**
		 * 淘宝商详率，实际使用时需要除以10000
		 */
		private Double tbWaresDetailRate;

		/**
		 * 淘宝首唤率*商详率，实际使用时需要除以10000
		 */
		private Double tbFirstCallAndWaresDetailRate;

		/**
		 * 一键复苏开关：0关闭，1开启
		 */
		private Short oneClickRecovery;

		/**
		 * ROI系数，正数，精确到两位小数
		 */
		private Double roiCoefficient;

		/**
		 * 百度标签定向（新），格式如：{白名单且}-{白名单且},{白名单或}-{白名单或}&{黑名单且}-{黑名单且},{黑名单或}-{黑名单或}
		 */
		private String besTagsOrientation;

		/**
		 * ADX App跑量覆盖，正数，精确到1位小数
		 */
		private Double adxAppRvCover;

        /**
         * 无广告位id投放配率
         */
        private Integer adxTagIdRate;

        /**
         * 是否支持 oCPR  0.否 1.是
         */
        private Short supportOcpr;

        public Short getSupportOcpr() {
            return supportOcpr;
        }

        public void setSupportOcpr(Short supportOcpr) {
            this.supportOcpr = supportOcpr;
        }

        public Integer getAdxTagIdRate() {
            return adxTagIdRate;
        }

        public void setAdxTagIdRate(Integer adxTagIdRate) {
            this.adxTagIdRate = adxTagIdRate;
        }

        public Double getAdxAppRvCover() {
			return adxAppRvCover;
		}

		public void setAdxAppRvCover(Double adxAppRvCover) {
			this.adxAppRvCover = adxAppRvCover;
		}

		public Double getRoiCoefficient() {
			return roiCoefficient;
		}

		public void setRoiCoefficient(Double roiCoefficient) {
			this.roiCoefficient = roiCoefficient;
		}

		public String getBesTagsOrientation() {
			return besTagsOrientation;
		}

		public void setBesTagsOrientation(String besTagsOrientation) {
			this.besTagsOrientation = besTagsOrientation;
		}

		public Short getOneClickRecovery() {
			return oneClickRecovery;
		}

		public void setOneClickRecovery(Short oneClickRecovery) {
			this.oneClickRecovery = oneClickRecovery;
		}

		public Double getTbFirstCallAndWaresDetailRate() {
			return tbFirstCallAndWaresDetailRate;
		}

		public void setTbFirstCallAndWaresDetailRate(Double tbFirstCallAndWaresDetailRate) {
			this.tbFirstCallAndWaresDetailRate = tbFirstCallAndWaresDetailRate;
		}

		public Double getTbWaresDetailRate() {
			return tbWaresDetailRate;
		}

		public void setTbWaresDetailRate(Double tbWaresDetailRate) {
			this.tbWaresDetailRate = tbWaresDetailRate;
		}

		public String getOsVersionOrientation() {
			return osVersionOrientation;
		}

		public void setOsVersionOrientation(String osVersionOrientation) {
			this.osVersionOrientation = osVersionOrientation;
		}

		public Short getParticipationRate() {
			return participationRate;
		}

		public void setParticipationRate(Short participationRate) {
			this.participationRate = participationRate;
		}

		public Short getFirstCallOptimization() {
			return firstCallOptimization;
		}

		public void setFirstCallOptimization(Short firstCallOptimization) {
			this.firstCallOptimization = firstCallOptimization;
		}

		public Short getRiskControl() {
			return riskControl;
		}

		public void setRiskControl(Short riskControl) {
			this.riskControl = riskControl;
		}

		public Short getAdxId() {
			return adxId;
		}

		public void setAdxId(Short adxId) {
			this.adxId = adxId;
		}

        public String getCrowdPackageOrientation() {
            return crowdPackageOrientation;
        }

        public void setCrowdPackageOrientation(String crowdPackageOrientation) {
            this.crowdPackageOrientation = crowdPackageOrientation;
        }

		public Long getDownloadLandingPageId() {
			return downloadLandingPageId;
		}

		public void setDownloadLandingPageId(Long downloadLandingPageId) {
			this.downloadLandingPageId = downloadLandingPageId;
		}

		public Integer getRta() {
			return rta;
		}

		public void setRta(Integer rta) {
			this.rta = rta;
		}

		public String getRtaParam() {
			return rtaParam;
		}

		public void setRtaParam(String rtaParam) {
			this.rtaParam = rtaParam;
		}


		public Integer getAdxAppIdRate() {
			return adxAppIdRate;
		}

		public void setAdxAppIdRate(Integer adxAppIdRate) {
			this.adxAppIdRate = adxAppIdRate;
		}

		public String getBdTagsOrientation() {
			return bdTagsOrientation;
		}

		public void setBdTagsOrientation(String bdTagsOrientation) {
			this.bdTagsOrientation = bdTagsOrientation;
		}

		public Short getAdxPriceType() {
			return adxPriceType;
		}

		public void setAdxPriceType(Short adxPriceType) {
			this.adxPriceType = adxPriceType;
		}

		public Double getAdxTargetCpa() {
			return adxTargetCpa;
		}

		public void setAdxTargetCpa(Double adxTargetCpa) {
			this.adxTargetCpa = adxTargetCpa;
		}

		public String getLandingPageEndJumpUrl() {
			return landingPageEndJumpUrl;
		}

		public void setLandingPageEndJumpUrl(String landingPageEndJumpUrl) {
			this.landingPageEndJumpUrl = landingPageEndJumpUrl;
		}

		public String getMediaAppPackageRule() {
			return mediaAppPackageRule;
		}

		public void setMediaAppPackageRule(String mediaAppPackageRule) {
			this.mediaAppPackageRule = mediaAppPackageRule;
		}

		public Integer getMediaAppPackageRate() {
			return mediaAppPackageRate;
		}

		public void setMediaAppPackageRate(Integer mediaAppPackageRate) {
			this.mediaAppPackageRate = mediaAppPackageRate;
		}

		public String getBdTags() {
			return bdTags;
		}

		public void setBdTags(String bdTags) {
			this.bdTags = bdTags;
		}

		public Double getAdxPrice() {
			return adxPrice;
		}

		public void setAdxPrice(Double adxPrice) {
			this.adxPrice = adxPrice;
		}

		public Double getAdxBudgetDaily() {
			return adxBudgetDaily;
		}

		public void setAdxBudgetDaily(Double adxBudgetDaily) {
			this.adxBudgetDaily = adxBudgetDaily;
		}

        public Short getPageType() {
            return pageType;
        }

        public void setPageType(Short pageType) {
            this.pageType = pageType;
        }

        public String getPackageName() {
            return packageName;
        }

        public void setPackageName(String packageName) {
            this.packageName = packageName;
        }

        public String getJumpUrl() {
            return jumpUrl;
        }

        public void setJumpUrl(String jumpUrl) {
            this.jumpUrl = jumpUrl;
        }

        public String getViewUrl() {
            return viewUrl;
        }

        public void setViewUrl(String viewUrl) {
            this.viewUrl = viewUrl;
        }

        public String getClickUrl() {
            return clickUrl;
        }

        public void setClickUrl(String clickUrl) {
            this.clickUrl = clickUrl;
        }

        public String getVideoPlayStartUrl() {
            return videoPlayStartUrl;
        }

        public void setVideoPlayStartUrl(String videoPlayStartUrl) {
            this.videoPlayStartUrl = videoPlayStartUrl;
        }

        public String getVideoPlayEndUrl() {
            return videoPlayEndUrl;
        }

        public void setVideoPlayEndUrl(String videoPlayEndUrl) {
            this.videoPlayEndUrl = videoPlayEndUrl;
        }

        public String getDeeplinkStartUrl() {
            return deeplinkStartUrl;
        }

        public void setDeeplinkStartUrl(String deeplinkStartUrl) {
            this.deeplinkStartUrl = deeplinkStartUrl;
        }

        public String getDeeplinkSuccessUrl() {
            return deeplinkSuccessUrl;
        }

        public void setDeeplinkSuccessUrl(String deeplinkSuccessUrl) {
            this.deeplinkSuccessUrl = deeplinkSuccessUrl;
        }

        public String getDeeplinkFailUrl() {
            return deeplinkFailUrl;
        }

        public void setDeeplinkFailUrl(String deeplinkFailUrl) {
            this.deeplinkFailUrl = deeplinkFailUrl;
        }

        public String getAppPackageRule() {
            return appPackageRule;
        }

        public void setAppPackageRule(String appPackageRule) {
            this.appPackageRule = appPackageRule;
        }

        public Integer getAppPackageRate() {
            return appPackageRate;
        }

        public void setAppPackageRate(Integer appPackageRate) {
            this.appPackageRate = appPackageRate;
        }

        public String getDeviceOrientation() {
            return deviceOrientation;
        }

        public void setDeviceOrientation(String deviceOrientation) {
            this.deviceOrientation = deviceOrientation;
        }
    }

    public TicketAppExtendVo getTicketAppExtendVo() {
        return ticketAppExtendVo;
    }

    public void setTicketAppExtendVo(TicketAppExtendVo ticketAppExtendVo) {
        this.ticketAppExtendVo = ticketAppExtendVo;
    }
}
