package com.bxm.adsmanager.model.vo;
/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the
 * confidential and proprietary information of bianxianmao.com ("Confidential
 * Information"). You shall not disclose such Confidential Information and shall
 * use it only in accordance with the terms of the license agreement you entered
 * into with bianxianmao.com.
 */


import java.io.Serializable;
import java.util.Date;

/**
 * <h3></h3>
 * @author hcmony
 * @since V1.0.0, 2017/12/12 15:06
 */
public class AdpositionVo implements Serializable{

	private static final long serialVersionUID = 4638242873581146582L;

    private String id;   //广告位id 自己拼成的

	private String mediaName;//媒体名称

	private String name;  //广告位名称

	private String appkey; //appkey

	private String business; //business

	private Long appbusinessId;//对应的表id

	private String onlineTime;//上线时间

    private String positionId;//positionId
    private String positionIdCodeName;//广告位代号

	private String mediaIdCodeName;//媒体代号

    /**
     * 媒体创建时间
     */
    private Date mediaOnlineTime;

    /**
     * 媒体类型code
     */
    private String mediaType;

    /**
     * 媒体类型名称
     */
    private String mediaTypeName;

    /**
     * 媒体分类名称
     */
    private String mediaClass;

    /**
     * 媒体分类ID
     */
    private String mediaClassId;

    /**
     * 媒体子分类名称
     */
    private String mediaChildClass;

    /**
     * 媒体子分类ID
     */
    private String mediaChildClassId;

    /**
     * ADX广告配置ID
     * 广告位场景
     * 广告位场景, 这里直接返回对应类型的文字
     * 广告位类型的描述：多图文、单图文等
     * 最低出价，单位为元
     */
    private Long appEntranceAdxId;
    private String positionType;
    private String positionTypeName;
    private String positionTypeDesc;
    private Double minimumPriceForYuan;

    //ADX素材
    private AdxNative adxNative;
    private AdxPicture adxPicture;
    private AdxText adxText;
    private AdxNativeVideo adxNativeVideo;
    private Byte positionScene;


    private Byte dockingMethod;
    private String imageSize;

    /**
     * 所属国家
     */
    private String country;

    public static class AdxNative {
        /**
         * 标题内容最大长度限制
         */
        private Integer titleMaximumLength;

        /**
         * 文本内容限制。{type}-{maximum_len},{type}-{maximum_len}。type：1- 选填、2- 必填，maximum_len：最大长度限制
         */
        private String contentConstraints;

        /**
         * icon尺寸限制。{type-height-width-maximum_kb}。type：1- 选填、2- 必填，height：高，width：宽，maximum_kb：最大KB限制
         */
        private String iconConstraints;

        /**
         * 图片格式：JPG,JPEG,PNG,GIF
         */
        private String pictureFormats;

        /**
         * 图片尺寸约束。{height-width-maximum_kb},{height-width-maximum_kb}。height：高，width：宽，maximum_kb：KB限制
         */
        private String pictureConstraints;

        public Integer getTitleMaximumLength() {
            return titleMaximumLength;
        }

        public void setTitleMaximumLength(Integer titleMaximumLength) {
            this.titleMaximumLength = titleMaximumLength;
        }

        public String getContentConstraints() {
            return contentConstraints;
        }

        public void setContentConstraints(String contentConstraints) {
            this.contentConstraints = contentConstraints;
        }

        public String getIconConstraints() {
            return iconConstraints;
        }

        public void setIconConstraints(String iconConstraints) {
            this.iconConstraints = iconConstraints;
        }

        public String getPictureFormats() {
            return pictureFormats;
        }

        public void setPictureFormats(String pictureFormats) {
            this.pictureFormats = pictureFormats;
        }

        public String getPictureConstraints() {
            return pictureConstraints;
        }

        public void setPictureConstraints(String pictureConstraints) {
            this.pictureConstraints = pictureConstraints;
        }
    }

    public static class AdxPicture {
        /**
         * 图片格式：JPG,JPEG,PNG,GIF
         */
        private String pictureFormats;

        /**
         * 图片尺寸约束。{height-width-maximum_kb},{height-width-maximum_kb}。height：高，width：宽，maximum_kb：KB限制
         */
        private String pictureConstraints;

        public String getPictureFormats() {
            return pictureFormats;
        }

        public void setPictureFormats(String pictureFormats) {
            this.pictureFormats = pictureFormats;
        }

        public String getPictureConstraints() {
            return pictureConstraints;
        }

        public void setPictureConstraints(String pictureConstraints) {
            this.pictureConstraints = pictureConstraints;
        }
    }

    public static class AdxText {
        /**
         * 标题内容最大长度限制
         */
        private Integer titleMaximumLength;

        /**
         * 文本内容限制。{type}-{maximum_len},{type}-{maximum_len}。type：1- 选填、2- 必填，maximum_len：最大长度限制
         */
        private String contentConstraints;

        public Integer getTitleMaximumLength() {
            return titleMaximumLength;
        }

        public void setTitleMaximumLength(Integer titleMaximumLength) {
            this.titleMaximumLength = titleMaximumLength;
        }

        public String getContentConstraints() {
            return contentConstraints;
        }

        public void setContentConstraints(String contentConstraints) {
            this.contentConstraints = contentConstraints;
        }
    }

    public static class AdxNativeVideo {
        private String coverPictureConstraints;
        private String iconConstraints;
        private String largeSizeConstraints;
        private String pictureFormats;
        private String titleConstraints;
        private String contentConstraints;
        private String videoSize;
        private Byte playType;
        private String videoFormats;

        public String getCoverPictureConstraints() {
            return this.coverPictureConstraints;
        }

        public void setCoverPictureConstraints(String coverPictureConstraints) {
            this.coverPictureConstraints = coverPictureConstraints;
        }

        public String getIconConstraints() {
            return this.iconConstraints;
        }

        public void setIconConstraints(String iconConstraints) {
            this.iconConstraints = iconConstraints;
        }

        public String getLargeSizeConstraints() {
            return this.largeSizeConstraints;
        }

        public void setLargeSizeConstraints(String largeSizeConstraints) {
            this.largeSizeConstraints = largeSizeConstraints;
        }

        public String getPictureFormats() {
            return this.pictureFormats;
        }

        public void setPictureFormats(String pictureFormats) {
            this.pictureFormats = pictureFormats;
        }

        public String getTitleConstraints() {
            return this.titleConstraints;
        }

        public void setTitleConstraints(String titleConstraints) {
            this.titleConstraints = titleConstraints;
        }

        public String getContentConstraints() {
            return this.contentConstraints;
        }

        public void setContentConstraints(String contentConstraints) {
            this.contentConstraints = contentConstraints;
        }

        public String getVideoSize() {
            return this.videoSize;
        }

        public void setVideoSize(String videoSize) {
            this.videoSize = videoSize;
        }

        public Byte getPlayType() {
            return this.playType;
        }

        public void setPlayType(Byte playType) {
            this.playType = playType;
        }

        public String getVideoFormats() {
            return this.videoFormats;
        }

        public void setVideoFormats(String videoFormats) {
            this.videoFormats = videoFormats;
        }


    }


    public Long getAppbusinessId() {
		return appbusinessId;
	}

	public void setAppbusinessId(Long appbusinessId) {
		this.appbusinessId = appbusinessId;
	}

	public String getId() {
		return this.appkey+"-"+this.business;
	}

	public String getMediaName() {
		return mediaName;
	}

	public void setMediaName(String mediaName) {
		this.mediaName = mediaName;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public void setAppkey(String appkey) {
		this.appkey = appkey;
	}

	public void setBusiness(String business) {
		this.business = business;
	}

	public String getAppkey() {
		return appkey;
	}

	public String getBusiness() {
		return business;
	}

	public String getOnlineTime() {
		return onlineTime;
	}

	public void setOnlineTime(String onlineTime) {
		this.onlineTime = onlineTime;
	}

    public String getPositionId() {
        return positionId;
    }

    public void setPositionId(String positionId) {
        this.positionId = positionId;
    }

    public String getPositionIdCodeName() {
        return positionIdCodeName;
    }

    public void setPositionIdCodeName(String positionIdCodeName) {
        this.positionIdCodeName = positionIdCodeName;
    }

    public String getMediaIdCodeName() {
        return mediaIdCodeName;
    }

    public void setMediaIdCodeName(String mediaIdCodeName) {
        this.mediaIdCodeName = mediaIdCodeName;
    }

    public Date getMediaOnlineTime() {
        return mediaOnlineTime;
    }

    public void setMediaOnlineTime(Date mediaOnlineTime) {
        this.mediaOnlineTime = mediaOnlineTime;
    }

    public String getMediaType() {
        return mediaType;
    }

    public void setMediaType(String mediaType) {
        this.mediaType = mediaType;
    }

    public String getMediaTypeName() {
        return mediaTypeName;
    }

    public void setMediaTypeName(String mediaTypeName) {
        this.mediaTypeName = mediaTypeName;
    }

    public String getMediaClass() {
        return mediaClass;
    }

    public void setMediaClass(String mediaClass) {
        this.mediaClass = mediaClass;
    }

    public String getMediaClassId() {
        return mediaClassId;
    }

    public void setMediaClassId(String mediaClassId) {
        this.mediaClassId = mediaClassId;
    }

    public String getMediaChildClass() {
        return mediaChildClass;
    }

    public void setMediaChildClass(String mediaChildClass) {
        this.mediaChildClass = mediaChildClass;
    }

    public String getMediaChildClassId() {
        return mediaChildClassId;
    }

    public void setMediaChildClassId(String mediaChildClassId) {
        this.mediaChildClassId = mediaChildClassId;
    }

    public Long getAppEntranceAdxId() {
        return appEntranceAdxId;
    }

    public void setAppEntranceAdxId(Long appEntranceAdxId) {
        this.appEntranceAdxId = appEntranceAdxId;
    }

    public String getPositionType() {
        return positionType;
    }

    public void setPositionType(String positionType) {
        this.positionType = positionType;
    }

    public String getPositionTypeName() {
        return positionTypeName;
    }

    public void setPositionTypeName(String positionTypeName) {
        this.positionTypeName = positionTypeName;
    }

    public String getPositionTypeDesc() {
        return positionTypeDesc;
    }

    public void setPositionTypeDesc(String positionTypeDesc) {
        this.positionTypeDesc = positionTypeDesc;
    }

    public Double getMinimumPriceForYuan() {
        return minimumPriceForYuan;
    }

    public void setMinimumPriceForYuan(Double minimumPriceForYuan) {
        this.minimumPriceForYuan = minimumPriceForYuan;
    }

    public AdxNative getAdxNative() {
        return adxNative;
    }

    public void setAdxNative(AdxNative adxNative) {
        this.adxNative = adxNative;
    }

    public AdxPicture getAdxPicture() {
        return adxPicture;
    }

    public void setAdxPicture(AdxPicture adxPicture) {
        this.adxPicture = adxPicture;
    }

    public AdxText getAdxText() {
        return adxText;
    }

    public void setAdxText(AdxText adxText) {
        this.adxText = adxText;
    }

    public AdxNativeVideo getAdxNativeVideo() {
        return adxNativeVideo;
    }

    public void setAdxNativeVideo(AdxNativeVideo adxNativeVideo) {
        this.adxNativeVideo = adxNativeVideo;
    }

    public Byte getPositionScene() {
        return positionScene;
    }

    public void setPositionScene(Byte positionScene) {
        this.positionScene = positionScene;
    }

    public Byte getDockingMethod() {
        return dockingMethod;
    }

    public void setDockingMethod(Byte dockingMethod) {
        this.dockingMethod = dockingMethod;
    }

    public String getImageSize() {
        return imageSize;
    }

    public void setImageSize(String imageSize) {
        this.imageSize = imageSize;
    }

    public String getCountry() {
        return country;
    }

    public void setCountry(String country) {
        this.country = country;
    }
}
