package com.bxm.adsmanager.model.vo;

import cn.afterturn.easypoi.excel.annotation.Excel;
import cn.afterturn.easypoi.excel.annotation.ExcelCollection;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

@Data
public class AdvertiserImgExcelVo extends UrlExcelSupport implements Serializable {

    private static final long serialVersionUID = -1480260062393709929L;

    @Excel(name = "广告主ID", needMerge = true)
    private Long advertiserId;

    @Excel(name = "广告主名称", needMerge = true, width = 20)
    private String advertiserName;

    @ExcelCollection(name = "主体信息")
    private List<UrlObject> infoUrlObjects;

    @ExcelCollection(name = "资质信息")
    private List<QualifyUrlObject> qualifyUrlObjects;

    @Excel(name = "落地页链接", needMerge = true, isHyperlink = true, width = 30)
    private String landingPageUrl;


    @Data
    public static class UrlObject extends UrlExcelSupport{
        @Excel(name = "类别", width = 20)
        public String name;
        @Excel(name ="图片链接", width = 35, isHyperlink = true)
        public String url;
    }

    @Data
    public static class QualifyUrlObject extends UrlObject{
        @Excel(name = "行业类型", mergeVertical = true, width = 20)
        private String qualifyTypeName;

        @Excel(name = "产品名称", mergeVertical = true, width = 20)
        private String content;
    }
}
