package com.bxm.adsmanager.model.vo;

import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * Description 广告主所有的券， 在一段时间内消耗的金额， 信息
 *
 * @author hxpeng
 * <p>
 * Date 2019/1/3 10:45
 */
@Data
@NoArgsConstructor
public class AdvertiserTicketConsumeInfoVO implements Serializable {
    private static final long serialVersionUID = -6853476356556317099L;

    /**
     * cpc 券消耗值
     */
    private BigDecimal cpcTicketConsume;

    /**
     * cpa 券消耗值
     */
    private BigDecimal cpaTicketConsume;



    public AdvertiserTicketConsumeInfoVO(BigDecimal cpcTicketConsume, BigDecimal cpaTicketConsume) {
        this.cpcTicketConsume = cpcTicketConsume;
        this.cpaTicketConsume = cpaTicketConsume;
    }
}
