package com.bxm.adsmanager.model.vo;

import lombok.Data;

import java.util.List;

/**
 * @author jingyu.li
 * @date 2022-11-18
 */
@Data
public class AppEntranceEditVO {
    /**
     * 新增挽留（默认前置）
     */
    private Byte newWanliu;

    /**
     * 广告位挽留弹窗开启地域，以逗号分隔
     */
    private String stayWindowdsRegion;

    /**
     * 广告位挽留弹窗开启时段，以逗号分隔
     */
    private String stayWindowdsTime;

    /**
     * 更多精彩（默认前置）
     */
    private Byte more;

    /**
     * 浮标素材是否前置：0不前置，1-前置
     */
    private Integer needFloatMaterial;

    /**
     * 合作类型（1 分成、2 采买、3 RTB）
     */
    private Byte cooperationType;

    List<AppKeyBusiness> appKeyBusinessList;

    @Data
    public static class AppKeyBusiness {

        /**
         * appkey
         */
        private String appKey;
        /**
         * positionId,可与appKey组合为adPositionId
         */
        private String business;
    }
}
