package com.bxm.adsmanager.model.vo;

import lombok.Data;

import java.util.List;

/**
 * @author yirenjie
 * createDate:  2018/12/4
 */
@Data
public class AutoAlarmVo {
    private String mediaName; // 媒体名称
    private String positionName; // 广告位名称
    private String appkey;      // 媒体代号
    private String alarmId;     // 预警id
    private Integer dimension;  //
    private String name;    // 负责人名字
    private Integer amount; // 数量
    private String leastAlarmTime;  // 最近报警时间
    private List<SubStatue> subStatus; // 字列表

    @Data
    public static class SubStatue {
        private Long id;
        private String indicateScope; //指标范围
        private Integer change; // 波动幅度
        private Integer status; // 处理进度（0：待处理;1:处理中;2:处理完成）
        private Integer reason;  // 归根原因;1:媒体原因、2:媒介原因、3:系统原因
        private String response;    // 响应时长
        private String detail;  // 备注
        private Integer level; // 1:黄色;2:红色
        private String createTime;
        private Boolean unread; // true 未读, false 已读
    }
}
