package com.bxm.adsmanager.model.vo;

import lombok.Data;

import java.math.BigDecimal;
import java.math.RoundingMode;

/**
 * @author tangx
 * @date 2022/10/19 9:42
 */
@Data
public class CvrStatisticVo {


    /**
     * 小时时间
     */
    private String dateTime;

    /**
     * 媒体
     */
    private String mediaName;

    /**
     * 点击数
     */
    private Integer click;

    /**
     * 回传成功数
     */
    private Integer feedback_success;

    /**
     * CVR 百分比
     */
    private String cvr;

    /**
     * 实际转化数
     */
    private Integer receivers;

    /**
     * 扣量数
     */
    private Integer minus;


    /**
     * 扣量数
     */
    private Integer minusTotal;

    /**
     * 补量数
     */
    private Integer plus;

    /**
     * 实际转化成本
     */
    private Double actualCost;


    public Double computeCvr() {
        if (this.getClick() == null || this.getFeedback_success() == null) {
            return 0d;
        }
        return this.getClick() == 0 ? 0 : new BigDecimal(this.getFeedback_success()).divide(new BigDecimal(this.getClick()),4, RoundingMode.HALF_UP).doubleValue();
    }

}
