package com.bxm.adsmanager.model.vo;

import com.bxm.adsmanager.model.base.BasePageVo;

import java.io.Serializable;
import java.util.List;

/**
 * @author hcmony
 * @create 2016-12-07 上午10:19
 */
public class Pagination extends BasePageVo implements Serializable {

    private static final long serialVersionUID = -3220830836796228820L;

    private Object condition;

    private String id;

    private List<?> list;

    private Integer sort;

    public Pagination() {

    }

    public Pagination(int pageNo, int pageSize, int totalCount) {
        super(pageNo, pageSize, totalCount);
    }

    public Pagination(int pageNo, int pageSize, int totalCount, List<?> list) {
        super(pageNo, pageSize, totalCount);
        this.list = list;
    }

    public Object getCondition() {
        return condition;
    }

    public int getFirstResult() {
        return (pageNo - 1) * pageSize;
    }

    public String getId() {
        return id;
    }

    public List<?> getList() {
        return list;
    }

    public Integer getSort() {
        return sort;
    }

    public void setCondition(Object condition) {
        this.condition = condition;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setList(List<?> list) {
        this.list = list;
    }

    public void setSort(Integer sort) {
        this.sort = sort;
    }
}
