package com.bxm.adsmanager.model.vo;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

import lombok.Data;

/**
 * 素材 列表数据对象<br/>
 *
 * @author zhengwangeng
 * @since 2021-12-7
 */
@Data
public class PanguCreativeListVO implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * ID
     */
    private Long id;

    /**
     * 图片
     */
    private String picture;

    /**
     * 标签：多个用逗号分割
     */
    private String tags;

    /**
     * 尺寸
     */
    private String size;

    /**
     * 文件格式
     */
    private String format;

    /**
     * md5
     */
    private String md5;

    /**
     * 状态。0- 停用、1- 启用 2删除
     */
    private Short status;

    /**
     * 30天曝光
     */
    private Long thirtyOpen;

    /**
     * 30天点击
     */
    private Long thirtyClick;

    /**
     * 30天点击率
     */
    private BigDecimal thirtyClickRate;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 修改人
     */
    private String modifyUser;

    /**
     * 修改时间
     */
    private Date modifyTime;
}
