package com.bxm.adsmanager.model.vo;

import cn.afterturn.easypoi.excel.annotation.Excel;
import com.bxm.adsmanager.model.dao.precharge.PrechargeDeveloperRelation;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * @author tangx
 * @date 2020/5/12 15:50
 */
@Data
public class PrechargeConfigVo implements Serializable {

    @Excel(name = "账户ID")
    private Long id;

    /**
     * 账户名称
     */
    @Excel(name = "账户名称")
    private String accountName;

    /**
     * 媒体代号
     */
    @Excel(name = "开发者代号")
    private String mediaCode;

    /**
     * 媒介经理
     */
    @Excel(name = "媒体运营")
    private String mjs;

    @Excel(name = "BD")
    private String bds;

    @Excel(name = "昨日消耗")
    private BigDecimal yesterdayConsume;

    @Excel(name = "上月消耗")
    private BigDecimal lastMonthConsume;

    @Excel(name = "当月消耗")
    private BigDecimal currentMonthConsume;

    @Excel(name = "剩余金额")
    private BigDecimal balance;

    private Byte bindingPlatform;

    private Byte correctStatus;

    @Excel(name = "修正数据状态")
    private String correctStatusForExcel;

    /**
     * 拒绝原因
     */
    private String refuseReason;

    /**
     * 合同编号
     */
    private String contractNum;

    /**
     * 合同主体
     */
    private String contractSubject;

    /**
     * 合同开始时间
     */
    private String contractStartDate;

    /**
     * 合同结束时间
     */
    private String contractEndDate;

    /**
     * 配置的开发者
     */
    private List<PrechargeDeveloperRelation> providerList;


}
