package com.bxm.adsmanager.model.vo;

import cn.afterturn.easypoi.excel.annotation.Excel;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author tangx
 * @date 2021/3/31 17:26
 */
@Data
public class PrechargeCorrectVo {

    private Long id;

    /**
     * 预付配置id
     */
    private Long accountId;

    /**
     * 预付配置名称
     */
    private String accountName;

    /**
     * 修正日期
     */
    private String datetime;

    /**
     * 修正金额
     */
    private BigDecimal correctAmount;

    /**
     * 修正类型 1.增加 2.减少
     */
    private Byte correctType;

    /**
     * 修正前余额
     */
    private BigDecimal originBalance;

    /**
     * 预期修正后的余额
     */
    private BigDecimal expectBalance;

    /**
     * 审核后最终余额
     */
    private BigDecimal finalBalance;

    /**
     * 昨日消耗金额
     */
    private BigDecimal yesterdayConsume;

    /**
     * 修正原因
     */
    private String correctReason;

    /**
     * 审核状态 0.待审核 1.审核通过 2.审核拒绝
     */
    private Byte auditStatus;

    /**
     * 审核拒绝原因
     */
    private String refuseReason;

    /**
     * 审核后的余额
     */
    private BigDecimal auditBalance;

    /**
     * 记录类型：1.修正数据 2.切换账户
     */
    private Byte recordType;


    private String createUser;

    private Date createTime;

    private String modifyUser;

    private Date modifyTime;
}
