package com.bxm.adsmanager.model.vo;

import cn.afterturn.easypoi.excel.annotation.Excel;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author tangx
 * @date 2020/5/12 15:50
 */
@Data
public class PrechargeRecordVo implements Serializable {

    private static final long serialVersionUID = -4933832647443150411L;

    private Long id;

    /**
     * 日期
     */
    @Excel(name = "日期")
    private String datetime;

    /**
     * 账户名称
     */
    @Excel(name = "账户名称")
    private String accountName;

    /**
     * 预付账号id
     */
    @Excel(name = "账户ID")
    private Long accountId;

    @Excel(name = "充值金额")
    private BigDecimal rechargeAmount;

    /**
     * 消耗金额
     */
    @Excel(name = "消耗金额")
    private BigDecimal consumeAmount;

    /**
     * 修正金额
     */
    @Excel(name = "修正金额")
    private BigDecimal correctAmount;

    private String rechargeAmountExport;

    private String consumeAmountExport;

    /**
     * 余额
     */
    @Excel(name = "余额")
    private BigDecimal balance;

}
