package com.bxm.adsmanager.model.vo;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

import com.bxm.warcar.utils.localdate.LocalDateTimeHelper;
import com.fasterxml.jackson.annotation.JsonFormat;

import cn.afterturn.easypoi.excel.annotation.Excel;
import lombok.Data;

/**
 * 代理数据（下游）.</br>
 * Created by zhengwangeng on 2022/6/24.
 */
@Data
public class ProxyChannelDataVO implements Serializable {

    private static final long serialVersionUID = 1L;


    /*-------------------------------- 渠道收益数据 --------------------------------*/
    /**
     * 主键ID
     */
    private Long id;

    /**
     * 日期
     */
    //@JsonFormat(pattern = LocalDateTimeHelper.PATTERN_STR10, timezone = "GMT+8")
    @Excel(name = "日期", orderNum = "0")
    private String thedate;

    /**
     * 代理名称
     */
    @Excel(name = "上游代理名称", orderNum = "1")
    private String agencyName;

    /**
     * 渠道号
     */
    @Excel(name = "渠道号", orderNum = "3")
    private String channelNo;

    /**
     * 收入
     */
    @Excel(name = "变现猫收入", orderNum = "4")
    private BigDecimal income;

    /**
     * 有效点击
     */
    @Excel(name = "变现猫有效点击数", orderNum = "5")
    private Long validClick;

    /**
     * 有效点击单价
     */
    @Excel(name = "变现猫有效点击单价", orderNum = "6")
    private BigDecimal validClickPrice;

    /**
     * 质量系数
     */
    @Excel(name = "质量系数", orderNum = "7")
    private BigDecimal qualityFactor;

    /**
     * CPS佣金
     */
    @Excel(name = "变现猫CPS佣金", orderNum = "8")
    private BigDecimal cpsBrokerage;

    /**
     * 质量分1
     */
    private BigDecimal qualityScoreOne;

    /**
     * 质量分2
     */
    private BigDecimal qualityScoreTwo;


    /**
     * 质量分3
     */
    private BigDecimal qualityScoreThree;

    /**
     * 质量分4
     */
    private BigDecimal qualityScoreFour;

    /*-------------------------------- 渠道数据 --------------------------------*/
    /**
     * 产品名称
     */
    @Excel(name = "产品名称", orderNum = "2")
    private String productName;

    /**
     * 外放代理人code，系统内媒介和销售角色的用户code
     */
    private String proxyCode;

    /**
     * 外放代理人名称
     */
    @Excel(name = "外放代理人", orderNum = "14")
    private String proxyName;

    /*-------------------------------- 下游数据 --------------------------------*/
    ///**
    // * id
    // */
    //private Long id;
    //
    ///**
    // * 日期
    // */
    //@JsonFormat(pattern = LocalDateTimeHelper.PATTERN_STR10, timezone = "GMT+8")
    //private Date thedate;
    //
    ///**
    // * 代理名称
    // */
    //private String agencyName;
    //
    ///**
    // * 渠道号
    // */
    //private String channelNo;

    /**
     * 下游
     */
    @Excel(name = "下游代理名称", orderNum = "9")
    private String ds;

    /**
     * 下游有效点击数
     */
    @Excel(name = "下游有效点击数", orderNum = "10")
    private String dsValidClick;

    /**
     * 下游单价
     */
    @Excel(name = "下游有效点击单价", orderNum = "11")
    private BigDecimal dsPrice;

    /**
     * 下游CPS佣金
     */
    @Excel(name = "下游CPS佣金", orderNum = "12")
    private BigDecimal dsCpsBrokerage;

    /**
     * 下游收入
     */
    @Excel(name = "下游收益", orderNum = "13")
    private BigDecimal dsIncome;


    /**
     * 利润
     */
    private BigDecimal profit;

    public BigDecimal getProfit() {
        //利润=变现猫收入-下游收益
        if (income != null && dsIncome != null) {
            return income.subtract(dsIncome);
        }
        return null;
    }
}
