package com.bxm.adsmanager.model.vo;

import com.bxm.adsmanager.model.dao.rtb.RtbSpeedControl;
import lombok.Data;

/**
 * tbl_rtb_speed_control
 * @author 
 */
@Data
public class RtbSpeedControlVo {
    private Long id;

    /**
     * 广告位id
     */
    private String positionId;

    /**
     * 广告组 ID，根据不同的平台有不同的含义, 为空则表示匹配当前广告位任何广告组 ID
     */
    private String adGroupId;

    /**
     * 广告券 ID，活动配置下没有值
     */
    private String adTicketId;

    /**
     * 行为类型
     */
    private String convType;

    /**
     * 控制回传数量
     */
    private Integer count;

    /**
     * 启用日期，格式：yyyy-MM-dd
     */
    private String date;

    /**
     * 开始时间，格式：HH:mm:ss
     */
    private String startTime;

    /**
     * 结束时间，格式：HH:mm:ss
     */
    private String endTime;

    /**
     * 启用状态 0.关闭 1.开启
     */
    private Integer enable;
}