/*
 * Copyright 2018 bianxianmao.com All right reserved. This software is the
 * confidential and proprietary information of bianxianmao.com ("Confidential
 * Information"). You shall not disclose such Confidential Information and shall
 * use it only in accordance with the terms of the license agreement you entered
 * into with bianxianmao.com.
 */

package com.bxm.adsmanager.model.vo.adprofit;

import com.bxm.commons.currency.Money;

public class AdProfitAllVo {

	/** datetime */  
	private String datetime;

	/** 广告总消耗 */
	private Long totalProfit;
	private Double totalProfitShow;

    /** 媒体预估收益 */
    private Integer profit;
    private Double profitShow;

    /** 扣量金额 */  
    private Integer profitDeduct;
    private Double profitDeductShow;

    /** 实际收益 */  
    private Integer profitActual;
    private Double profitActualShow;

	/** 公司利润 */
	private Integer consume;
    private Double consumeShow;

    /** 录入状态 */  
    private Short status;

    /** 媒体收益录入状态 */  
    private Short mediaStatus;

    /** 广告位收益录入状态 */  
    private Short positionStatus;
    
    /** 变现猫收益 */  
    private Double bxmProfitShow;
    
    /**
     * 实际消耗占比-广告实际消耗/广告总消耗*100%
     */
    private String actualConsumeRate;
    
    /**
     * 代理成本
     */
    private Double agentRebate;
    
    /**
     * BD成本
     */
    private Double bdRebate;
    
    /**
     * 独立成本
     */
    private Double fixCost;
    
    /**
     * 毛利率-公司利润/广告总消耗*100%
     */
    private String grossProfitRate;
    
	public Integer getConsume() {
		return consume;
	}

	public void setConsume(Integer consume) {
		this.consume = consume;
	}

	public Long getTotalProfit() {
		return totalProfit;
	}

	public void setTotalProfit(Long totalProfit) {
		this.totalProfit = totalProfit;
	}

	public double getTotalProfitShow() {
		if (totalProfit != null) {
			Money money = Money.ofLi(totalProfit);
			totalProfitShow = money.getYuan();
		}
		return totalProfitShow != null ? totalProfitShow : 0.0;
	}

	public void setTotalProfitShow(Double totalProfitShow) {
		this.totalProfitShow = totalProfitShow;
	}

	public Double getConsumeShow() {
		if (consume != null) {
			Money money = Money.ofLi(consume);
			consumeShow = money.getYuan();
		}
		return consumeShow != null ? consumeShow : 0.0;
	}

	public void setConsumeShow(Double consumeShow) {
		this.consumeShow = consumeShow;
	}

	public Double getBxmProfitShow() {
    	if (consume != null && profitActual != null) {
			Money money = Money.ofLi(consume -profitActual);
			bxmProfitShow = money.getYuan();
		}
		return bxmProfitShow != null ? bxmProfitShow : 0.0;
	}

	public void setBxmProfitShow(Double bxmProfitShow) {
		this.bxmProfitShow = bxmProfitShow;
	}

	public Double getProfitShow() {
    	if (profit != null) {
			Money money = Money.ofLi(profit);
			profitShow = money.getYuan();
		}
		return profitShow != null ? profitShow : 0.0;
	}

	public void setProfitShow(Double profitShow) {
		this.profitShow = profitShow;
	}

	public Double getProfitDeductShow() {
		if (profitDeduct != null) {
			Money money = Money.ofLi(profitDeduct);
			profitDeductShow = money.getYuan();
		}
		return profitDeductShow != null ? profitDeductShow : 0.0;
	}

	public void setProfitDeductShow(Double profitDeductShow) {
		this.profitDeductShow = profitDeductShow;
	}

	public Double getProfitActualShow() {
		if (profitActual != null) {
			Money money = Money.ofLi(profitActual);
			profitActualShow = money.getYuan();
		}
		return profitActualShow != null ? profitActualShow : 0.0;
	}

	public void setProfitActualShow(Double profitActualShow) {
		this.profitActualShow = profitActualShow;
	}

	public String getDatetime() {
        return datetime;
    }

    public void setDatetime(String datetime) {
        this.datetime = datetime == null ? null : datetime.trim();
    }

    public Integer getProfit() {
        return profit;
    }

    public void setProfit(Integer profit) {
        this.profit = profit;
    }

    public Integer getProfitDeduct() {
        return profitDeduct;
    }

    public void setProfitDeduct(Integer profitDeduct) {
        this.profitDeduct = profitDeduct;
    }

    public Integer getProfitActual() {
        return profitActual;
    }

    public void setProfitActual(Integer profitActual) {
        this.profitActual = profitActual;
    }

    public Short getStatus() {
        return status;
    }

    public void setStatus(Short status) {
        this.status = status;
    }

    public Short getMediaStatus() {
        return mediaStatus;
    }

    public void setMediaStatus(Short mediaStatus) {
        this.mediaStatus = mediaStatus;
    }

    public Short getPositionStatus() {
        return positionStatus;
    }

    public void setPositionStatus(Short positionStatus) {
        this.positionStatus = positionStatus;
    }
    
    //新增字段
    public String getActualConsumeRate() {
        return actualConsumeRate;
    }

    public void setActualConsumeRate(String actualConsumeRate) {
        this.actualConsumeRate = actualConsumeRate;
    }

    public Double getAgentRebate() {
        return agentRebate;
    }

    public void setAgentRebate(Double agentRebate) {
        this.agentRebate = agentRebate;
    }

    public Double getBdRebate() {
        return bdRebate;
    }

    public void setBdRebate(Double bdRebate) {
        this.bdRebate = bdRebate;
    }

    public Double getFixCost() {
        return fixCost;
    }

    public void setFixCost(Double fixCost) {
        this.fixCost = fixCost;
    }

    public String getGrossProfitRate() {
        return grossProfitRate;
    }

    public void setGrossProfitRate(String grossProfitRate) {
        this.grossProfitRate = grossProfitRate;
    }
    

}